/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.memory.Dictionary;
import sun.jvm.hotspot.memory.LoaderConstraintTable;
import sun.jvm.hotspot.memory.PlaceholderTable;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Metadata;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.OopField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class SystemDictionary {
    private static AddressField dictionaryField;
    private static AddressField sharedDictionaryField;
    private static AddressField placeholdersField;
    private static AddressField loaderConstraintTableField;
    private static OopField javaSystemLoaderField;
    private static AddressField objectKlassField;
    private static AddressField classLoaderKlassField;
    private static AddressField stringKlassField;
    private static AddressField systemKlassField;
    private static AddressField threadKlassField;
    private static AddressField threadGroupKlassField;
    private static AddressField methodHandleKlassField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("SystemDictionary");
        dictionaryField = type.getAddressField("_dictionary");
        sharedDictionaryField = type.getAddressField("_shared_dictionary");
        placeholdersField = type.getAddressField("_placeholders");
        loaderConstraintTableField = type.getAddressField("_loader_constraints");
        javaSystemLoaderField = type.getOopField("_java_system_loader");
        objectKlassField = type.getAddressField(SystemDictionary.WK_KLASS("Object_klass"));
        classLoaderKlassField = type.getAddressField(SystemDictionary.WK_KLASS("ClassLoader_klass"));
        stringKlassField = type.getAddressField(SystemDictionary.WK_KLASS("String_klass"));
        systemKlassField = type.getAddressField(SystemDictionary.WK_KLASS("System_klass"));
        threadKlassField = type.getAddressField(SystemDictionary.WK_KLASS("Thread_klass"));
        threadGroupKlassField = type.getAddressField(SystemDictionary.WK_KLASS("ThreadGroup_klass"));
        methodHandleKlassField = type.getAddressField(SystemDictionary.WK_KLASS("MethodHandle_klass"));
    }

    private static String WK_KLASS(String name) {
        return "_well_known_klasses[SystemDictionary::" + SystemDictionary.WK_KLASS_ENUM_NAME(name) + "]";
    }

    private static String WK_KLASS_ENUM_NAME(String kname) {
        return kname + "_knum";
    }

    public Dictionary dictionary() {
        Address tmp = dictionaryField.getValue();
        return (Dictionary)VMObjectFactory.newObject(Dictionary.class, tmp);
    }

    public Dictionary sharedDictionary() {
        Address tmp = sharedDictionaryField.getValue();
        return (Dictionary)VMObjectFactory.newObject(Dictionary.class, tmp);
    }

    public PlaceholderTable placeholders() {
        Address tmp = placeholdersField.getValue();
        return (PlaceholderTable)VMObjectFactory.newObject(PlaceholderTable.class, tmp);
    }

    public LoaderConstraintTable constraints() {
        Address tmp = placeholdersField.getValue();
        return (LoaderConstraintTable)VMObjectFactory.newObject(LoaderConstraintTable.class, tmp);
    }

    public static InstanceKlass getThreadKlass() {
        return (InstanceKlass)Metadata.instantiateWrapperFor(threadKlassField.getValue());
    }

    public static InstanceKlass getThreadGroupKlass() {
        return (InstanceKlass)Metadata.instantiateWrapperFor(threadGroupKlassField.getValue());
    }

    public static InstanceKlass getObjectKlass() {
        return (InstanceKlass)Metadata.instantiateWrapperFor(objectKlassField.getValue());
    }

    public static InstanceKlass getStringKlass() {
        return (InstanceKlass)Metadata.instantiateWrapperFor(stringKlassField.getValue());
    }

    public static InstanceKlass getClassLoaderKlass() {
        return (InstanceKlass)Metadata.instantiateWrapperFor(classLoaderKlassField.getValue());
    }

    public static InstanceKlass getSystemKlass() {
        return (InstanceKlass)Metadata.instantiateWrapperFor(systemKlassField.getValue());
    }

    public static InstanceKlass getMethodHandleKlass() {
        return (InstanceKlass)Metadata.instantiateWrapperFor(methodHandleKlassField.getValue());
    }

    public InstanceKlass getAbstractOwnableSynchronizerKlass() {
        return (InstanceKlass)this.find("java/util/concurrent/locks/AbstractOwnableSynchronizer", null, null);
    }

    public static Oop javaSystemLoader() {
        return SystemDictionary.newOop(javaSystemLoaderField.getValue());
    }

    private static Oop newOop(OopHandle handle) {
        return VM.getVM().getObjectHeap().newOop(handle);
    }

    public Klass find(String className, Oop classLoader, Oop protectionDomain) {
        Symbol sym = VM.getVM().getSymbolTable().probe(className);
        if (sym == null) {
            return null;
        }
        return this.find(sym, classLoader, protectionDomain);
    }

    public Klass find(Symbol className, Oop classLoader, Oop protectionDomain) {
        Dictionary dict = this.dictionary();
        long hash = dict.computeHash(className, classLoader);
        int index = dict.hashToIndex(hash);
        return dict.find(index, hash, className, classLoader, protectionDomain);
    }

    public void allClassesDo(final ClassVisitor v) {
        ClassVisitor visitor = new ClassVisitor(){

            @Override
            public void visit(Klass k) {
                for (Klass l = k; l != null; l = l.arrayKlassOrNull()) {
                    v.visit(l);
                }
            }
        };
        this.classesDo(visitor);
        VM.getVM().getUniverse().basicTypeClassesDo(visitor);
    }

    public void classesDo(ClassVisitor v) {
        this.dictionary().classesDo(v);
    }

    public void classesDo(ClassAndLoaderVisitor v) {
        this.dictionary().classesDo(v);
    }

    public void primArrayClassesDo(ClassAndLoaderVisitor v) {
        this.placeholders().primArrayClassesDo(v);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                SystemDictionary.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }

    public static interface ClassAndLoaderVisitor {
        public void visit(Klass var1, Oop var2);
    }

    public static interface ClassVisitor {
        public void visit(Klass var1);
    }
}

