/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.catalog.query;

import java.net.URI;
import java.util.ArrayList;
import org.xmlresolver.CatalogManager;
import org.xmlresolver.catalog.entry.Entry;
import org.xmlresolver.catalog.entry.EntryCatalog;
import org.xmlresolver.catalog.entry.EntryDelegatePublic;
import org.xmlresolver.catalog.entry.EntryPublic;
import org.xmlresolver.catalog.query.QueryCatalog;
import org.xmlresolver.catalog.query.QueryDelegatePublic;
import org.xmlresolver.catalog.query.QueryResult;
import org.xmlresolver.catalog.query.QuerySystem;

public class QueryPublic
extends QueryCatalog {
    public final String systemId;
    public final String publicId;

    public QueryPublic(String systemId, String publicId) {
        this.systemId = systemId;
        this.publicId = publicId;
    }

    @Override
    protected QueryResult lookup(CatalogManager manager, EntryCatalog catalog) {
        Object query;
        QueryResult queryResult;
        if (this.systemId != null && (queryResult = ((QuerySystem)(query = new QuerySystem(this.systemId))).lookup(manager, catalog)).resolved()) {
            return queryResult;
        }
        if (this.publicId != null) {
            for (Entry entry : catalog.entries(Entry.Type.PUBLIC)) {
                EntryPublic entry2 = (EntryPublic)entry;
                if (!entry2.preferPublic && this.systemId != null || !entry2.publicId.equals(this.publicId)) continue;
                return new QueryResult(entry2.uri);
            }
            ArrayList<EntryDelegatePublic> delegated = new ArrayList<EntryDelegatePublic>();
            for (Entry raw : catalog.entries(Entry.Type.DELEGATE_PUBLIC)) {
                int pos;
                EntryDelegatePublic entry = (EntryDelegatePublic)raw;
                if (!entry.preferPublic && this.systemId != null || !this.publicId.startsWith(entry.publicIdStart)) continue;
                for (pos = 0; pos < delegated.size() && entry.publicIdStart.length() <= ((EntryDelegatePublic)delegated.get((int)pos)).publicIdStart.length(); ++pos) {
                }
                delegated.add(pos, entry);
            }
            if (!delegated.isEmpty()) {
                ArrayList<URI> arrayList = new ArrayList<URI>();
                for (EntryDelegatePublic entry : delegated) {
                    arrayList.add(entry.catalog);
                }
                return new QueryDelegatePublic(this.systemId, this.publicId, arrayList);
            }
        }
        return QueryResult.EMPTY_RESULT;
    }
}

