/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.LogSequenceNumber;
import com.sleepycat.db.internal.DbUtil;

public class TransactionStats {
    private int st_nrestores;
    private LogSequenceNumber st_last_ckp;
    private long st_time_ckp;
    private int st_last_txnid;
    private int st_maxtxns;
    private int st_naborts;
    private int st_nbegins;
    private int st_ncommits;
    private int st_nactive;
    private int st_nsnapshot;
    private int st_maxnactive;
    private int st_maxnsnapshot;
    private Active[] st_txnarray;
    private int st_region_wait;
    private int st_region_nowait;
    private int st_regsize;

    TransactionStats() {
    }

    public int getNumRestores() {
        return this.st_nrestores;
    }

    public LogSequenceNumber getLastCkp() {
        return this.st_last_ckp;
    }

    public long getTimeCkp() {
        return this.st_time_ckp;
    }

    public int getLastTxnId() {
        return this.st_last_txnid;
    }

    public int getMaxTxns() {
        return this.st_maxtxns;
    }

    public int getNaborts() {
        return this.st_naborts;
    }

    public int getNumBegins() {
        return this.st_nbegins;
    }

    public int getNumCommits() {
        return this.st_ncommits;
    }

    public int getNactive() {
        return this.st_nactive;
    }

    public int getNumSnapshot() {
        return this.st_nsnapshot;
    }

    public int getMaxNactive() {
        return this.st_maxnactive;
    }

    public int getMaxNsnapshot() {
        return this.st_maxnsnapshot;
    }

    public Active[] getTxnarray() {
        return this.st_txnarray;
    }

    public int getRegionWait() {
        return this.st_region_wait;
    }

    public int getRegionNowait() {
        return this.st_region_nowait;
    }

    public int getRegSize() {
        return this.st_regsize;
    }

    public String toString() {
        return "TransactionStats:\n  st_nrestores=" + this.st_nrestores + "\n  st_last_ckp=" + this.st_last_ckp + "\n  st_time_ckp=" + this.st_time_ckp + "\n  st_last_txnid=" + this.st_last_txnid + "\n  st_maxtxns=" + this.st_maxtxns + "\n  st_naborts=" + this.st_naborts + "\n  st_nbegins=" + this.st_nbegins + "\n  st_ncommits=" + this.st_ncommits + "\n  st_nactive=" + this.st_nactive + "\n  st_nsnapshot=" + this.st_nsnapshot + "\n  st_maxnactive=" + this.st_maxnactive + "\n  st_maxnsnapshot=" + this.st_maxnsnapshot + "\n  st_txnarray=" + DbUtil.objectArrayToString(this.st_txnarray, "st_txnarray") + "\n  st_region_wait=" + this.st_region_wait + "\n  st_region_nowait=" + this.st_region_nowait + "\n  st_regsize=" + this.st_regsize;
    }

    public static class Active {
        private int txnid;
        private int parentid;
        private int pid;
        private LogSequenceNumber lsn;
        private LogSequenceNumber read_lsn;
        private int mvcc_ref;
        private int status;
        private int xa_status;
        private byte[] xid;
        private String name;

        Active() {
        }

        public int getTxnId() {
            return this.txnid;
        }

        public int getParentId() {
            return this.parentid;
        }

        public int getPid() {
            return this.pid;
        }

        public LogSequenceNumber getLsn() {
            return this.lsn;
        }

        public LogSequenceNumber getReadLsn() {
            return this.read_lsn;
        }

        public int getMultiversionRef() {
            return this.mvcc_ref;
        }

        public int getStatus() {
            return this.status;
        }

        public int getXaStatus() {
            return this.xa_status;
        }

        public byte[] getXId() {
            return this.xid;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "Active:\n      txnid=" + this.txnid + "\n      parentid=" + this.parentid + "\n      pid=" + this.pid + "\n      lsn=" + this.lsn + "\n      read_lsn=" + this.read_lsn + "\n      mvcc_ref=" + this.mvcc_ref + "\n      status=" + this.status + "\n      xa_status=" + this.xa_status + "\n      xid=" + DbUtil.byteArrayToString(this.xid) + "\n      name=" + this.name;
        }
    }
}

