/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.console.karaf.internal;

import java.util.Arrays;
import java.util.List;
import org.apache.karaf.shell.api.console.Candidate;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.completers.StringsCompleter;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.console.ConsoleCommandCompleter;
import org.openhab.core.io.console.extensions.ConsoleCommandExtension;

@NonNullByDefault(value={})
public class CompleterWrapper
implements Completer {
    private final @Nullable ConsoleCommandCompleter completer;
    private final String command;
    private final String commandDescription;
    private final @Nullable String globalCommand;

    public CompleterWrapper(ConsoleCommandExtension command, boolean scoped) {
        this.completer = command.getCompleter();
        this.command = command.getCommand();
        this.commandDescription = command.getDescription();
        this.globalCommand = !scoped ? "openhab:" + this.command : null;
    }

    public int complete(Session session, CommandLine commandLine, List<String> candidates) {
        String arg;
        String localGlobalCommand = this.globalCommand;
        if (commandLine.getCursorArgumentIndex() == 0) {
            StringsCompleter stringsCompleter = new StringsCompleter();
            stringsCompleter.getStrings().add(this.command);
            if (localGlobalCommand != null) {
                stringsCompleter.getStrings().add(localGlobalCommand);
            }
            return stringsCompleter.complete(session, commandLine, candidates);
        }
        if (commandLine.getArguments().length > 1 && !(arg = commandLine.getArguments()[0]).equals(this.command) && !arg.equals(localGlobalCommand)) {
            return -1;
        }
        if (commandLine.getCursorArgumentIndex() < 0) {
            return -1;
        }
        ConsoleCommandCompleter localCompleter = this.completer;
        if (localCompleter == null) {
            return -1;
        }
        String[] args = commandLine.getArguments();
        boolean result = localCompleter.complete(Arrays.copyOfRange(args, 1, args.length), commandLine.getCursorArgumentIndex() - 1, commandLine.getArgumentPosition(), candidates);
        return result ? commandLine.getBufferPosition() - commandLine.getArgumentPosition() : -1;
    }

    public void completeCandidates(Session session, CommandLine commandLine, List<Candidate> candidates) {
        if (commandLine.getCursorArgumentIndex() == 0) {
            String localGlobalCommand;
            String arg = commandLine.getArguments()[0];
            if (this.command.startsWith(arg = arg.substring(0, commandLine.getArgumentPosition()))) {
                candidates.add(new Candidate(this.command, this.command, null, this.commandDescription, null, null, true));
            }
            if ((localGlobalCommand = this.globalCommand) != null && localGlobalCommand.startsWith(arg)) {
                candidates.add(new Candidate(localGlobalCommand, localGlobalCommand, null, this.commandDescription, null, null, true));
            }
            return;
        }
        super.completeCandidates(session, commandLine, candidates);
    }
}

