/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.cli.util;

public class OsArch {
    private String os;
    private String arch;
    private boolean legacy;

    public OsArch(String os, String arch) {
        this(os, arch, false);
    }

    public OsArch(String os, String arch, boolean legacy) {
        this.os = os;
        this.arch = arch;
        this.legacy = legacy;
    }

    public String os() {
        return this.os;
    }

    public String arch() {
        return this.arch;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public boolean isWindows() {
        return "win32".equals(this.os);
    }

    public String envVar(String var) {
        if (this.isWindows()) {
            return "%" + var + "%";
        }
        return "$" + var;
    }

    public String path(String path) {
        if (this.isWindows() && ((String)(path = ((String)path).replaceAll("/", "\\\\"))).startsWith("~")) {
            path = "%HOMEPATH%" + ((String)path).substring(1);
        }
        return path;
    }
}

