/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import org.jivesoftware.smack.packet.MessageOrPresenceBuilder;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceView;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.id.StanzaIdSource;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.ToStringUtil;

public final class PresenceBuilder
extends MessageOrPresenceBuilder<Presence, PresenceBuilder>
implements PresenceView {
    static final PresenceBuilder EMPTY = new PresenceBuilder(() -> null);
    Presence.Type type = Presence.Type.available;
    String status;
    Byte priority;
    Presence.Mode mode;

    PresenceBuilder(Presence presence, String stanzaId) {
        super((Stanza)presence, stanzaId);
        this.copyFromPresence(presence);
    }

    PresenceBuilder(Presence presence, StanzaIdSource stanzaIdSource) {
        super((Stanza)presence, stanzaIdSource);
        this.copyFromPresence(presence);
    }

    PresenceBuilder(StanzaIdSource stanzaIdSource) {
        super(stanzaIdSource);
    }

    PresenceBuilder(String stanzaId) {
        super(stanzaId);
    }

    private void copyFromPresence(Presence presence) {
        this.type = presence.getType();
        this.status = presence.getStatus();
        this.priority = presence.getPriorityByte();
        this.mode = presence.getMode();
    }

    @Override
    protected void addStanzaSpecificAttributes(ToStringUtil.Builder builder2) {
        builder2.addValue("type", (Object)this.type).addValue("mode", (Object)this.mode).addValue("priority", this.priority).addValue("status", this.status);
    }

    public PresenceBuilder ofType(Presence.Type type) {
        this.type = Objects.requireNonNull(type, "Type cannot be null");
        return this.getThis();
    }

    public PresenceBuilder setStatus(String status) {
        this.status = status;
        return this.getThis();
    }

    public PresenceBuilder setPriority(int priority) {
        if (priority < -128 || priority > 127) {
            throw new IllegalArgumentException("Priority value " + priority + " is not valid. Valid range is -128 through 127.");
        }
        Byte priorityByte = (byte)priority;
        return this.setPriority(priorityByte);
    }

    public PresenceBuilder setPriority(Byte priority) {
        this.priority = priority;
        return this.getThis();
    }

    public PresenceBuilder setMode(Presence.Mode mode) {
        this.mode = mode;
        return this.getThis();
    }

    @Override
    public PresenceBuilder getThis() {
        return this;
    }

    @Override
    public Presence build() {
        return new Presence(this);
    }

    @Override
    public Presence.Type getType() {
        return this.type;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public int getPriority() {
        return this.getPriorityByte();
    }

    @Override
    public byte getPriorityByte() {
        if (this.priority == null) {
            return 0;
        }
        return this.priority;
    }

    @Override
    public Presence.Mode getMode() {
        if (this.mode == null) {
            return Presence.Mode.available;
        }
        return this.mode;
    }
}

