/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.remote.internal.hub;

import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.internal.remote.internal.hub.MethodArgsSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Message;
import org.gradle.internal.serialize.Serializer;

class JavaSerializationBackedMethodArgsSerializer
implements MethodArgsSerializer {
    private static final Object[] ZERO_ARGS = new Object[0];
    private final ClassLoader classLoader;

    public JavaSerializationBackedMethodArgsSerializer(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Serializer<Object[]> forTypes(Class<?>[] types) {
        if (types.length == 0) {
            return new EmptyArraySerializer();
        }
        return new ArraySerializer();
    }

    private class ArraySerializer
    implements Serializer<Object[]> {
        private ArraySerializer() {
        }

        public Object[] read(Decoder decoder) throws Exception {
            return (Object[])Message.receive((InputStream)decoder.getInputStream(), (ClassLoader)JavaSerializationBackedMethodArgsSerializer.this.classLoader);
        }

        public void write(Encoder encoder, Object[] value) throws Exception {
            Message.send((Object)value, (OutputStream)encoder.getOutputStream());
        }
    }

    private static class EmptyArraySerializer
    implements Serializer<Object[]> {
        private EmptyArraySerializer() {
        }

        public Object[] read(Decoder decoder) {
            return ZERO_ARGS;
        }

        public void write(Encoder encoder, Object[] value) {
        }
    }
}

