/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.components.internal;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.reporting.components.internal.SourceSetRenderer;
import org.gradle.api.reporting.components.internal.TypeAwareBinaryRenderer;
import org.gradle.api.tasks.diagnostics.internal.text.TextReportBuilder;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.SourceComponentSpec;
import org.gradle.platform.base.VariantComponentSpec;
import org.gradle.reporting.ReportRenderer;
import org.gradle.util.internal.CollectionUtils;

public class ComponentRenderer
extends ReportRenderer<ComponentSpec, TextReportBuilder> {
    private final ReportRenderer<LanguageSourceSet, TextReportBuilder> sourceSetRenderer;
    private final ReportRenderer<BinarySpec, TextReportBuilder> binaryRenderer;

    public ComponentRenderer(ReportRenderer<LanguageSourceSet, TextReportBuilder> sourceSetRenderer, ReportRenderer<BinarySpec, TextReportBuilder> binaryRenderer) {
        this.sourceSetRenderer = sourceSetRenderer;
        this.binaryRenderer = binaryRenderer;
    }

    public void render(ComponentSpec component, TextReportBuilder builder) {
        builder.heading(StringUtils.capitalize((String)component.getDisplayName()));
        if (component instanceof SourceComponentSpec) {
            SourceComponentSpec sourceComponentSpec = (SourceComponentSpec)component;
            builder.getOutput().println();
            builder.collection("Source sets", (Collection)CollectionUtils.sort((Iterable)sourceComponentSpec.getSources().values(), SourceSetRenderer.SORT_ORDER), this.sourceSetRenderer, "source sets");
        }
        if (component instanceof VariantComponentSpec) {
            VariantComponentSpec variantComponentSpec = (VariantComponentSpec)component;
            builder.getOutput().println();
            builder.collection("Binaries", (Collection)CollectionUtils.sort((Iterable)variantComponentSpec.getBinaries().values(), TypeAwareBinaryRenderer.SORT_ORDER), this.binaryRenderer, "binaries");
        }
    }
}

