/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.gimmicks;

import java.io.Serializable;

public class LengthUnit
implements Serializable {
    public static final LengthUnit METER = new LengthUnit(1.0, "meter", "m");
    public static final LengthUnit KILOMETER = new LengthUnit(1000.0, "kilometer", "km");
    public static final LengthUnit DECIMETER = new LengthUnit(0.1, "decimeter", "dm");
    public static final LengthUnit CENTIMETER = new LengthUnit(0.01, "centimeter", "cm");
    public static final LengthUnit MILLIMETER = new LengthUnit(0.001, "millimeter", "mm");
    public static final LengthUnit MICROMETER = new LengthUnit(1.0E-6, "micrometer", "\u00ef\u00bf\u00bdm");
    public static final LengthUnit NANOMETER = new LengthUnit(1.0E-9, "nanometer", "nm");
    public static final LengthUnit PICOMETER = new LengthUnit(1.0E-12, "picometer", "pm");
    public static final LengthUnit ANGSTROM = new LengthUnit(1.0E-10, "\u00ef\u00bf\u00bdngstr\u00ef\u00bf\u00bdm", "\u00ef\u00bf\u00bd");
    public static final LengthUnit INCH = new LengthUnit(0.0254, "inch", "in");
    public static final LengthUnit FOOT = new LengthUnit(0.30479999999999996, "foot", "ft");
    protected double ratio;
    protected String name;
    protected String shortCut;

    public LengthUnit(double unitsPerMeter, String unitName, String unitShortCut) {
        this.ratio = unitsPerMeter;
        this.name = unitName;
        this.shortCut = unitShortCut;
    }

    public String getShortCut() {
        return this.shortCut;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getShortCut();
    }

    public double meterToUnit(double meter) {
        return meter / this.ratio;
    }

    public double unitToMeter(double units) {
        return units * this.ratio;
    }

    public double otherToUnit(double length, LengthUnit other) {
        return other.unitToMeter(length) / this.ratio;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        LengthUnit other = (LengthUnit)obj;
        return other.ratio == this.ratio && this.name.equals(other.name) && this.shortCut.equals(other.shortCut);
    }
}

