/*
 * Copyright LWJGL. All rights reserved.
 * License terms: https://www.lwjgl.org/license
 */

/**
 * The base LWJGL package. Contains functionality useful across all bindings.
 *
 * <p>LWJGL is a Java library that enables cross-platform access to popular native APIs useful in the development of graphics (OpenGL), audio (OpenAL) and
 * parallel computing (OpenCL) applications. This access is direct and high-performance, yet also wrapped in a type-safe and user-friendly layer, appropriate
 * for the Java ecosystem.</p>
 *
 * <p>LWJGL is an enabling technology and provides low-level access. It is not a framework and does not provide higher-level utilities than what the native
 * libraries expose. As such, novice programmers are encouraged to try one of the frameworks or game engines that make use of LWJGL, before working directly
 * with the library.</p>
 *
 * <p>LWJGL is open source software and freely available at no charge.</p>
 *
 * @see <a href="https://www.lwjgl.org/">www.lwjgl.org</a>
 */
@org.lwjgl.system.NonnullDefault
package org.lwjgl;
