/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.ArcConfig;
import io.quarkus.arc.deployment.IgnoreSplitPackageBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

public class SplitPackageProcessor {
    private static final Logger LOGGER = Logger.getLogger(SplitPackageProcessor.class);
    private static final Predicate<String> IGNORE_PACKAGE = new Predicate<String>(){

        @Override
        public boolean test(String packageName) {
            return packageName.startsWith("io.fabric8.kubernetes");
        }
    };

    @BuildStep
    void splitPackageDetection(ApplicationArchivesBuildItem archivesBuildItem, ArcConfig config, List<IgnoreSplitPackageBuildItem> excludedPackages, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> dummy) {
        HashMap<String, Set> packageToArchiveMap = new HashMap<String, Set>();
        ArrayList<Predicate<String>> packageSkipPredicates = new ArrayList<Predicate<String>>();
        if (config.ignoredSplitPackages().isPresent()) {
            packageSkipPredicates.addAll(this.initPredicates((Collection<String>)config.ignoredSplitPackages().get()));
        }
        for (IgnoreSplitPackageBuildItem exclusionBuildItem : excludedPackages) {
            packageSkipPredicates.addAll(this.initPredicates(exclusionBuildItem.getExcludedPackages()));
        }
        for (ApplicationArchive archive : archivesBuildItem.getAllApplicationArchives()) {
            for (ClassInfo classInfo : archive.getIndex().getKnownClasses()) {
                String packageName = DotNames.packageName((DotName)classInfo.name());
                packageToArchiveMap.compute(packageName, (key, val) -> {
                    Set returnValue = val == null ? new HashSet() : val;
                    returnValue.add(archive);
                    return returnValue;
                });
            }
        }
        StringBuilder splitPackagesWarning = new StringBuilder();
        for (String packageName : packageToArchiveMap.keySet()) {
            Set applicationArchives;
            if (IGNORE_PACKAGE.test(packageName)) continue;
            boolean skipEvaluation = false;
            for (Predicate predicate : packageSkipPredicates) {
                if (!predicate.test(packageName)) continue;
                skipEvaluation = true;
                break;
            }
            if (skipEvaluation || (applicationArchives = (Set)packageToArchiveMap.get(packageName)).size() <= 1) continue;
            splitPackagesWarning.append("\n- \"" + packageName + "\" found in ");
            Iterator iterator = applicationArchives.iterator();
            TreeSet<String> splitPackages = new TreeSet<String>();
            while (iterator.hasNext()) {
                ApplicationArchive next = (ApplicationArchive)iterator.next();
                ResolvedDependency dep = next.getResolvedDependency();
                if (dep == null) {
                    if (archivesBuildItem.getRootArchive().equals((Object)next)) {
                        splitPackages.add("application classes");
                        continue;
                    }
                    Iterator pathIterator = next.getResolvedPaths().iterator();
                    if (pathIterator.hasNext()) {
                        splitPackages.add(((Path)pathIterator.next()).toString());
                        continue;
                    }
                    splitPackages.add("unknown archive");
                    continue;
                }
                splitPackages.add(dep.toCompactCoords());
            }
            splitPackagesWarning.append(splitPackages.stream().collect(Collectors.joining(", ", "[", "]")));
        }
        if (splitPackagesWarning.length() > 0) {
            LOGGER.warnf("Detected a split package usage which is considered a bad practice and should be avoided. Following packages were detected in multiple archives: %s", (Object)splitPackagesWarning.toString());
        }
    }

    private List<Predicate<String>> initPredicates(Collection<String> exclusions) {
        String packMatch = ".*";
        ArrayList<Predicate<String>> predicates = new ArrayList<Predicate<String>>();
        for (final String exclusionExpression : exclusions) {
            if (exclusionExpression.endsWith(".*")) {
                final String pack = exclusionExpression.substring(0, exclusionExpression.length() - ".*".length());
                predicates.add(new Predicate<String>(){

                    @Override
                    public boolean test(String packageName) {
                        return packageName.equals(pack) || packageName.startsWith(pack + ".");
                    }
                });
                continue;
            }
            predicates.add(new Predicate<String>(){

                @Override
                public boolean test(String packageName) {
                    return packageName.equals(exclusionExpression);
                }
            });
        }
        return predicates;
    }
}

