/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.logging;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.logging.LogManager;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"})
class FileHandler
extends java.util.logging.FileHandler {
    private static int count = -1;
    private static int limit = -1;
    static String pattern = null;

    public FileHandler(String pattern, int limit, int count2) throws IOException, SecurityException {
        super(pattern, limit, count2);
    }

    public FileHandler() throws IOException, SecurityException {
        super(FileHandler.getPattern(), FileHandler.getLimit(), FileHandler.getCount());
    }

    private static int getLimit() {
        if (limit == -1) {
            String limitStr = LogManager.getLogManager().getProperty(FileHandler.class.getName() + ".limit");
            limit = 0;
            try {
                limit = Integer.parseInt(limitStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return limit;
    }

    private static String getPattern() {
        if (pattern == null) {
            pattern = LogManager.getLogManager().getProperty(FileHandler.class.getName() + ".pattern");
            String homeLocation = System.getProperty("net.java.sip.communicator.SC_HOME_DIR_LOCATION");
            String dirName = System.getProperty("net.java.sip.communicator.SC_HOME_DIR_NAME");
            if (homeLocation != null && dirName != null) {
                pattern = pattern == null ? homeLocation + "/" + dirName + "/log/jitsi%u.log" : pattern.replaceAll("\\%s", homeLocation + "/" + dirName);
            }
            if (pattern == null) {
                pattern = "./log/jitsi%u.log";
            }
            FileHandler.createDestinationDirectory(pattern);
        }
        return pattern;
    }

    private static int getCount() {
        if (count == -1) {
            String countStr = LogManager.getLogManager().getProperty(FileHandler.class.getName() + ".count");
            count = 1;
            try {
                count = Integer.parseInt(countStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return count;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private static void createDestinationDirectory(String pattern) {
        try {
            int ix = pattern.lastIndexOf(47);
            if (ix != -1) {
                String dirName = pattern.substring(0, ix);
                dirName = dirName.replaceAll("%h", System.getProperty("user.home"));
                dirName = dirName.replaceAll("%t", System.getProperty("java.io.tmpdir"));
                new File(dirName).mkdirs();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

