/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.deletefolders;

import java.io.IOException;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.deletefolders.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryDeleteFolders
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    public boolean argFromPrevious;
    public String[] arguments;
    private String success_condition;
    public String SUCCESS_IF_AT_LEAST_X_FOLDERS_DELETED = "success_when_at_least";
    public String SUCCESS_IF_ERRORS_LESS = "success_if_errors_less";
    public String SUCCESS_IF_NO_ERRORS = "success_if_no_errors";
    private String limit_folders;
    int NrErrors = 0;
    int NrSuccess = 0;
    boolean successConditionBroken = false;
    boolean successConditionBrokenExit = false;
    int limitFolders = 0;

    public JobEntryDeleteFolders(String n) {
        super(n, "");
        this.argFromPrevious = false;
        this.arguments = null;
        this.success_condition = this.SUCCESS_IF_NO_ERRORS;
        this.limit_folders = "10";
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.DELETE_FOLDERS);
    }

    public JobEntryDeleteFolders() {
        this("");
    }

    public JobEntryDeleteFolders(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryDeleteFolders je = (JobEntryDeleteFolders)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"arg_from_previous", (boolean)this.argFromPrevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)"success_condition", (String)this.success_condition));
        retval.append("      ").append(XMLHandler.addTagValue((String)"limit_folders", (String)this.limit_folders));
        retval.append("      <fields>").append(Const.CR);
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)this.arguments[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.argFromPrevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.success_condition = XMLHandler.getTagValue((Node)entrynode, (String)"success_condition");
            this.limit_folders = XMLHandler.getTagValue((Node)entrynode, (String)"limit_folders");
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.arguments = new String[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.arguments[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(Messages.getString("JobEntryDeleteFolders.UnableToLoadFromXml"), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.argFromPrevious = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_from_previous");
            this.limit_folders = rep.getJobEntryAttributeString(id_jobentry, "limit_folders");
            this.success_condition = rep.getJobEntryAttributeString(id_jobentry, "success_condition");
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "name");
            this.arguments = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = rep.getJobEntryAttributeString(id_jobentry, a, "name");
            }
        }
        catch (KettleException dbe) {
            throw new KettleException(Messages.getString("JobEntryDeleteFolders.UnableToLoadFromRepo", String.valueOf(id_jobentry)), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "arg_from_previous", this.argFromPrevious);
            rep.saveJobEntryAttribute(id_job, this.getID(), "limit_folders", this.limit_folders);
            rep.saveJobEntryAttribute(id_job, this.getID(), "success_condition", this.success_condition);
            if (this.arguments != null) {
                for (int i = 0; i < this.arguments.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "name", this.arguments[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobEntryDeleteFolders.UnableToSaveToRepo", String.valueOf(id_job)), (Throwable)dbe);
        }
    }

    @Override
    public Result execute(Result result, int nr, Repository rep, Job parentJob) throws KettleException {
        LogWriter log = LogWriter.getInstance();
        List rows = result.getRows();
        RowMetaAndData resultRow = null;
        result.setNrErrors(1L);
        result.setResult(false);
        this.NrErrors = 0;
        this.NrSuccess = 0;
        this.successConditionBroken = false;
        this.successConditionBrokenExit = false;
        this.limitFolders = Const.toInt((String)this.environmentSubstitute(this.getLimitFolders()), (int)10);
        if (this.argFromPrevious && log.isDetailed()) {
            log.logDetailed(this.toString(), Messages.getString("JobEntryDeleteFolders.FoundPreviousRows", String.valueOf(rows != null ? rows.size() : 0)), new Object[0]);
        }
        if (this.argFromPrevious && rows != null) {
            for (int iteration = 0; iteration < rows.size() && !parentJob.isStopped(); ++iteration) {
                if (this.successConditionBroken) {
                    log.logError(this.toString(), Messages.getString("JobEntryDeleteFolders.Error.SuccessConditionbroken", "" + this.NrErrors), new Object[0]);
                    result.setNrErrors((long)this.NrErrors);
                    result.setNrLinesDeleted((long)this.NrSuccess);
                    return result;
                }
                resultRow = (RowMetaAndData)rows.get(iteration);
                String args_previous = resultRow.getString(0, null);
                if (!Const.isEmpty((String)args_previous)) {
                    if (this.deleteFolder(args_previous)) {
                        this.updateSuccess();
                        continue;
                    }
                    this.updateErrors();
                    continue;
                }
                log.logError(this.toString(), Messages.getString("JobEntryDeleteFolders.Error.EmptyLine"), new Object[0]);
            }
        } else if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length && !parentJob.isStopped(); ++i) {
                if (this.successConditionBroken) {
                    log.logError(this.toString(), Messages.getString("JobEntryDeleteFolders.Error.SuccessConditionbroken", "" + this.NrErrors), new Object[0]);
                    result.setNrErrors((long)this.NrErrors);
                    result.setNrLinesDeleted((long)this.NrSuccess);
                    return result;
                }
                String realfilename = this.environmentSubstitute(this.arguments[i]);
                if (!Const.isEmpty((String)realfilename)) {
                    if (this.deleteFolder(realfilename)) {
                        this.updateSuccess();
                        continue;
                    }
                    this.updateErrors();
                    continue;
                }
                log.logError(this.toString(), Messages.getString("JobEntryDeleteFolders.Error.EmptyLine"), new Object[0]);
            }
        }
        if (log.isDetailed()) {
            log.logDetailed(this.toString(), "=======================================", new Object[0]);
            log.logDetailed(this.toString(), Messages.getString("JobEntryDeleteFolders.Log.Info.NrError", "" + this.NrErrors), new Object[0]);
            log.logDetailed(this.toString(), Messages.getString("JobEntryDeleteFolders.Log.Info.NrDeletedFolders", "" + this.NrSuccess), new Object[0]);
            log.logDetailed(this.toString(), "=======================================", new Object[0]);
        }
        result.setNrErrors((long)this.NrErrors);
        result.setNrLinesDeleted((long)this.NrSuccess);
        if (this.getSuccessStatus()) {
            result.setResult(true);
        }
        return result;
    }

    private void updateErrors() {
        ++this.NrErrors;
        if (this.checkIfSuccessConditionBroken()) {
            this.successConditionBroken = true;
        }
    }

    private boolean checkIfSuccessConditionBroken() {
        boolean retval = false;
        if (this.NrErrors > 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrErrors >= this.limitFolders && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private void updateSuccess() {
        ++this.NrSuccess;
    }

    private boolean getSuccessStatus() {
        boolean retval = false;
        if (this.NrErrors == 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrSuccess >= this.limitFolders && this.getSuccessCondition().equals(this.SUCCESS_IF_AT_LEAST_X_FOLDERS_DELETED) || this.NrErrors <= this.limitFolders && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean deleteFolder(String foldername) {
        FileObject filefolder;
        boolean rcode;
        LogWriter log;
        block14: {
            log = LogWriter.getInstance();
            rcode = false;
            filefolder = null;
            filefolder = KettleVFS.getFileObject((String)foldername);
            System.gc();
            if (filefolder.exists()) {
                if (filefolder.getType() == FileType.FOLDER) {
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobEntryDeleteFolders.ProcessingFolder", foldername), new Object[0]);
                    }
                    int Nr = filefolder.delete((FileSelector)new TextFileSelector());
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), Messages.getString("JobEntryDeleteFolders.TotalDeleted", foldername, String.valueOf(Nr)), new Object[0]);
                    }
                    rcode = true;
                } else {
                    log.logError(this.toString(), Messages.getString("JobEntryDeleteFolders.Error.NotFolder"), new Object[0]);
                }
                break block14;
            }
            if (log.isBasic()) {
                log.logBasic(this.toString(), Messages.getString("JobEntryDeleteFolders.FolderAlreadyDeleted", foldername), new Object[0]);
            }
            rcode = true;
        }
        Object var7_7 = null;
        if (filefolder == null) return rcode;
        try {
            filefolder.close();
            return rcode;
        }
        catch (IOException ex) {}
        return rcode;
        {
            catch (IOException e) {
                log.logError(this.toString(), Messages.getString("JobEntryDeleteFolders.CouldNotDelete", foldername, e.getMessage()), new Object[0]);
                Object var7_8 = null;
                if (filefolder == null) return rcode;
                try {
                    filefolder.close();
                    return rcode;
                }
                catch (IOException ex) {}
                return rcode;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (filefolder == null) throw throwable;
            try {
                filefolder.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void setPrevious(boolean argFromPrevious) {
        this.argFromPrevious = argFromPrevious;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        boolean res = JobEntryValidatorUtils.andValidator().validate(this, "arguments", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        for (int i = 0; i < this.arguments.length; ++i) {
            JobEntryValidatorUtils.andValidator().validate(this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (this.arguments != null) {
            ResourceReference reference = null;
            for (int i = 0; i < this.arguments.length; ++i) {
                String filename = jobMeta.environmentSubstitute(this.arguments[i]);
                if (reference == null) {
                    reference = new ResourceReference(this);
                    references.add(reference);
                }
                reference.getEntries().add(new ResourceEntry(filename, ResourceEntry.ResourceType.FILE));
            }
        }
        return references;
    }

    public boolean isArgFromPrevious() {
        return this.argFromPrevious;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void setSuccessCondition(String success_condition) {
        this.success_condition = success_condition;
    }

    public String getSuccessCondition() {
        return this.success_condition;
    }

    public void setLimitFolders(String limit_folders) {
        this.limit_folders = limit_folders;
    }

    public String getLimitFolders() {
        return this.limit_folders;
    }

    private class TextFileSelector
    implements FileSelector {
        private TextFileSelector() {
        }

        public boolean includeFile(FileSelectInfo info) {
            return true;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return true;
        }
    }
}

