/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.wlm.tracker;

import java.util.List;
import org.opensearch.core.tasks.resourcetracker.ResourceStats;
import org.opensearch.monitor.jvm.JvmStats;
import org.opensearch.wlm.QueryGroupTask;
import org.opensearch.wlm.tracker.ResourceUsageCalculator;

public class MemoryUsageCalculator
extends ResourceUsageCalculator {
    public static final long HEAP_SIZE_BYTES = JvmStats.jvmStats().getMem().getHeapMax().getBytes();
    public static final MemoryUsageCalculator INSTANCE = new MemoryUsageCalculator();

    private MemoryUsageCalculator() {
    }

    @Override
    public double calculateResourceUsage(List<QueryGroupTask> tasks) {
        return tasks.stream().mapToDouble(this::calculateTaskResourceUsage).sum();
    }

    @Override
    public double calculateTaskResourceUsage(QueryGroupTask task) {
        return 1.0f * (float)task.getTotalResourceUtilization(ResourceStats.MEMORY) / (float)HEAP_SIZE_BYTES;
    }
}

