/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.sort;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.SortField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.sort.BucketedSort;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortFieldAndFormat;
import org.opensearch.search.sort.SortOrder;

public class ScoreSortBuilder
extends SortBuilder<ScoreSortBuilder> {
    public static final String NAME = "_score";
    private static final SortFieldAndFormat SORT_SCORE = new SortFieldAndFormat(new SortField(null, SortField.Type.SCORE), DocValueFormat.RAW);
    private static final SortFieldAndFormat SORT_SCORE_REVERSE = new SortFieldAndFormat(new SortField(null, SortField.Type.SCORE, true), DocValueFormat.RAW);
    private static final ObjectParser<ScoreSortBuilder, Void> PARSER = new ObjectParser("_score", ScoreSortBuilder::new);

    public ScoreSortBuilder() {
        this.order(SortOrder.DESC);
    }

    public ScoreSortBuilder(StreamInput in) throws IOException {
        this.order(SortOrder.readFromStream(in));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.order.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(NAME);
        builder.field(ORDER_FIELD.getPreferredName(), (Object)this.order);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static ScoreSortBuilder fromXContent(XContentParser parser, String fieldName) {
        return (ScoreSortBuilder)PARSER.apply(parser, null);
    }

    @Override
    public SortFieldAndFormat build(QueryShardContext context) {
        if (this.order == SortOrder.DESC) {
            return SORT_SCORE;
        }
        return SORT_SCORE_REVERSE;
    }

    @Override
    public BucketedSort buildBucketedSort(QueryShardContext context, int bucketSize, BucketedSort.ExtraData extra) throws IOException {
        return new BucketedSort.ForFloats(context.bigArrays(), this.order, DocValueFormat.RAW, bucketSize, extra){

            @Override
            public boolean needsScores() {
                return true;
            }

            @Override
            public BucketedSort.ForFloats.Leaf forLeaf(LeafReaderContext ctx) throws IOException {
                return new BucketedSort.ForFloats.Leaf(ctx){
                    private Scorable scorer;
                    private float score;

                    @Override
                    public void setScorer(Scorable scorer) {
                        this.scorer = scorer;
                    }

                    @Override
                    protected boolean advanceExact(int doc) throws IOException {
                        assert (doc == this.scorer.docID()) : "expected scorer to be on [" + doc + "] but was on [" + this.scorer.docID() + "]";
                        this.score = this.scorer.score();
                        return true;
                    }

                    @Override
                    protected float docValue() {
                        return this.score;
                    }
                };
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ScoreSortBuilder other = (ScoreSortBuilder)object;
        return Objects.equals((Object)this.order, (Object)other.order);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.order});
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public ScoreSortBuilder rewrite(QueryRewriteContext ctx) throws IOException {
        return this;
    }

    static {
        PARSER.declareString((builder, order) -> builder.order(SortOrder.fromString(order)), ORDER_FIELD);
    }
}

