/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.opensearch.OpenSearchException;
import org.opensearch.common.Nullable;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.unit.Fuzziness;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.opensearch.index.mapper.DynamicKeyFieldMapper;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.KeywordFieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.SourceValueFetcher;
import org.opensearch.index.mapper.StringFieldType;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.SearchService;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.lookup.SearchLookup;

public final class FlatObjectFieldMapper
extends DynamicKeyFieldMapper {
    public static final String CONTENT_TYPE = "flat_object";
    public static final Object DOC_VALUE_NO_MATCH = new Object();
    static final String VALUE_AND_PATH_SUFFIX = "._valueAndPath";
    static final String VALUE_SUFFIX = "._value";
    static final String DOT_SYMBOL = ".";
    static final String EQUAL_SYMBOL = "=";
    public static final TypeParser PARSER = new TypeParser((n, c) -> new Builder((String)n));
    private final KeywordFieldMapper.KeywordFieldType valueFieldType;
    private final KeywordFieldMapper.KeywordFieldType valueAndPathFieldType;

    @Override
    public MappedFieldType keyedFieldType(String key) {
        return new FlatObjectFieldType(this.name() + DOT_SYMBOL + key, this.name(), this.valueFieldType, this.valueAndPathFieldType);
    }

    FlatObjectFieldMapper(String simpleName, FieldType fieldType, FlatObjectFieldType mappedFieldType) {
        super(simpleName, fieldType, mappedFieldType, FieldMapper.CopyTo.empty());
        assert (fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) <= 0);
        this.valueFieldType = mappedFieldType.valueFieldType;
        this.valueAndPathFieldType = mappedFieldType.valueAndPathFieldType;
    }

    @Override
    protected FlatObjectFieldMapper clone() {
        return (FlatObjectFieldMapper)super.clone();
    }

    @Override
    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
    }

    @Override
    public FlatObjectFieldType fieldType() {
        return (FlatObjectFieldType)super.fieldType();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        XContentParser ctxParser = context.parser();
        if (!(this.fieldType().isSearchable() || this.fieldType().isStored() || this.fieldType().hasDocValues())) {
            ctxParser.skipChildren();
            return;
        }
        if (ctxParser.currentToken() != XContentParser.Token.VALUE_NULL) {
            if (ctxParser.currentToken() != XContentParser.Token.START_OBJECT) {
                throw new ParsingException(ctxParser.getTokenLocation(), "[" + this.name() + "] unexpected token [" + String.valueOf(ctxParser.currentToken()) + "] in flat_object field value", new Object[0]);
            }
            this.parseObject(ctxParser, context);
        }
    }

    private void parseObject(XContentParser parser, ParseContext context) throws IOException {
        assert (parser.currentToken() == XContentParser.Token.START_OBJECT);
        parser.nextToken();
        LinkedList<String> path = new LinkedList<String>(Collections.singleton(this.fieldType().name()));
        HashSet<String> pathParts = new HashSet<String>();
        while (parser.currentToken() != XContentParser.Token.END_OBJECT) {
            this.parseToken(parser, context, path, pathParts);
        }
        this.createPathFields(context, pathParts);
    }

    private void createPathFields(ParseContext context, HashSet<String> pathParts) {
        for (String part : pathParts) {
            BytesRef value = new BytesRef((CharSequence)(this.name() + DOT_SYMBOL + part));
            if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
                context.doc().add((IndexableField)new Field(this.name(), value, (IndexableFieldType)this.fieldType));
            }
            if (this.fieldType().hasDocValues()) {
                context.doc().add((IndexableField)new SortedSetDocValuesField(this.name(), value));
                continue;
            }
            this.createFieldNamesField(context);
        }
    }

    private static String getDVPrefix(String rootFieldName) {
        return rootFieldName + DOT_SYMBOL;
    }

    private static String getPathPrefix(String path) {
        return path + EQUAL_SYMBOL;
    }

    private void parseToken(XContentParser parser, ParseContext context, Deque<String> path, HashSet<String> pathParts) throws IOException {
        if (parser.currentToken() == XContentParser.Token.FIELD_NAME) {
            String currentFieldName = parser.currentName();
            path.addLast(currentFieldName);
            parser.nextToken();
            this.parseToken(parser, context, path, pathParts);
            path.removeLast();
        } else if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
            parser.nextToken();
            while (parser.currentToken() != XContentParser.Token.END_ARRAY) {
                this.parseToken(parser, context, path, pathParts);
            }
            parser.nextToken();
        } else if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            parser.nextToken();
            while (parser.currentToken() != XContentParser.Token.END_OBJECT) {
                this.parseToken(parser, context, path, pathParts);
            }
            parser.nextToken();
        } else {
            String value = FlatObjectFieldMapper.parseValue(parser);
            if (value == null || value.length() > this.fieldType().ignoreAbove) {
                parser.nextToken();
                return;
            }
            NamedAnalyzer normalizer = this.fieldType().normalizer();
            if (normalizer != null) {
                value = KeywordFieldMapper.normalizeValue(normalizer, this.name(), value);
            }
            String leafPath = Strings.collectionToDelimitedString(path, (String)DOT_SYMBOL);
            String valueAndPath = FlatObjectFieldMapper.getPathPrefix(leafPath) + value;
            if (this.fieldType().isSearchable() || this.fieldType().isStored()) {
                context.doc().add((IndexableField)new Field(this.valueFieldType.name(), new BytesRef((CharSequence)value), (IndexableFieldType)this.fieldType));
                context.doc().add((IndexableField)new Field(this.valueAndPathFieldType.name(), new BytesRef((CharSequence)valueAndPath), (IndexableFieldType)this.fieldType));
            }
            if (this.fieldType().hasDocValues()) {
                context.doc().add((IndexableField)new SortedSetDocValuesField(this.valueFieldType.name(), new BytesRef((CharSequence)(FlatObjectFieldMapper.getDVPrefix(this.name()) + value))));
                context.doc().add((IndexableField)new SortedSetDocValuesField(this.valueAndPathFieldType.name(), new BytesRef((CharSequence)(FlatObjectFieldMapper.getDVPrefix(this.name()) + valueAndPath))));
            }
            pathParts.addAll(Arrays.asList(leafPath.substring(this.name().length() + 1).split("\\.")));
            parser.nextToken();
        }
    }

    private static String parseValue(XContentParser parser) throws IOException {
        switch (parser.currentToken()) {
            case VALUE_BOOLEAN: 
            case VALUE_NUMBER: 
            case VALUE_STRING: 
            case VALUE_NULL: {
                return parser.textOrNull();
            }
        }
        throw new ParsingException(parser.getTokenLocation(), "Unexpected value token type [" + String.valueOf(parser.currentToken()) + "]", new Object[0]);
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static final class FlatObjectFieldType
    extends StringFieldType {
        private final int ignoreAbove;
        private final String nullValue;
        private final String rootFieldName;
        private final KeywordFieldMapper.KeywordFieldType valueFieldType;
        private final KeywordFieldMapper.KeywordFieldType valueAndPathFieldType;

        public FlatObjectFieldType(String name, String rootFieldName, boolean isSearchable, boolean hasDocValues) {
            this(name, rootFieldName, FlatObjectFieldType.getKeywordFieldType(rootFieldName == null ? name : rootFieldName, FlatObjectFieldMapper.VALUE_SUFFIX, isSearchable, hasDocValues), FlatObjectFieldType.getKeywordFieldType(rootFieldName == null ? name : rootFieldName, FlatObjectFieldMapper.VALUE_AND_PATH_SUFFIX, isSearchable, hasDocValues));
        }

        public FlatObjectFieldType(String name, String rootFieldName, KeywordFieldMapper.KeywordFieldType valueFieldType, KeywordFieldMapper.KeywordFieldType valueAndPathFieldType) {
            super(name, valueFieldType.isSearchable(), false, valueFieldType.hasDocValues(), new TextSearchInfo(Defaults.FIELD_TYPE, null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER), Collections.emptyMap());
            assert (rootFieldName == null || name.length() > rootFieldName.length() && name.startsWith(rootFieldName));
            this.ignoreAbove = Integer.MAX_VALUE;
            this.nullValue = null;
            this.rootFieldName = rootFieldName;
            this.valueFieldType = valueFieldType;
            this.valueAndPathFieldType = valueAndPathFieldType;
        }

        static KeywordFieldMapper.KeywordFieldType getKeywordFieldType(final String rootField, String suffix, boolean isSearchable, boolean hasDocValue) {
            return new KeywordFieldMapper.KeywordFieldType(rootField + suffix, isSearchable, hasDocValue, Collections.emptyMap()){

                @Override
                protected String rewriteForDocValue(Object value) {
                    assert (value instanceof String);
                    return FlatObjectFieldMapper.getDVPrefix(rootField) + String.valueOf(value);
                }
            };
        }

        public KeywordFieldMapper.KeywordFieldType getValueFieldType() {
            return this.valueFieldType;
        }

        public KeywordFieldMapper.KeywordFieldType getValueAndPathFieldType() {
            return this.valueAndPathFieldType;
        }

        @Override
        public String typeName() {
            return FlatObjectFieldMapper.CONTENT_TYPE;
        }

        NamedAnalyzer normalizer() {
            return this.indexAnalyzer();
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(this.valueFieldType().name(), CoreValuesSourceType.BYTES);
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new SourceValueFetcher(this.name(), context, this.nullValue){

                @Override
                protected String parseSourceValue(Object value) {
                    String flatObjectKeywordValue = value.toString();
                    if (flatObjectKeywordValue.length() > ignoreAbove) {
                        return null;
                    }
                    NamedAnalyzer normalizer = this.normalizer();
                    if (normalizer == null) {
                        return flatObjectKeywordValue;
                    }
                    try {
                        return KeywordFieldMapper.normalizeValue(normalizer, this.name(), flatObjectKeywordValue);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            };
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom formats");
            }
            if (timeZone != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
            }
            if (this.rootFieldName != null) {
                return new FlatObjectDocValueFormat(FlatObjectFieldMapper.getDVPrefix(this.rootFieldName) + FlatObjectFieldMapper.getPathPrefix(this.name()));
            }
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support doc_value in root field");
        }

        @Override
        public boolean isAggregatable() {
            return false;
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }

        @Override
        protected BytesRef indexedValueForSearch(Object value) {
            if (this.getTextSearchInfo().getSearchAnalyzer() == Lucene.KEYWORD_ANALYZER) {
                return super.indexedValueForSearch(value);
            }
            if (value == null) {
                return null;
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return this.getTextSearchInfo().getSearchAnalyzer().normalize(this.name(), value.toString());
        }

        private KeywordFieldMapper.KeywordFieldType valueFieldType() {
            return this.rootFieldName == null ? this.valueFieldType : this.valueAndPathFieldType;
        }

        @Override
        public Query termQueryCaseInsensitive(Object value, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            return this.valueFieldType().termQueryCaseInsensitive(this.rewriteSearchValue(value), context);
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            return this.valueFieldType().termQuery(this.rewriteSearchValue(value), context);
        }

        @Override
        public Query termsQuery(List<?> values, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            ArrayList<String> parsedValues = new ArrayList<String>(values.size());
            for (Object value : values) {
                parsedValues.add(this.rewriteSearchValue(value));
            }
            return this.valueFieldType().termsQuery(parsedValues, context);
        }

        public String getSearchField() {
            return this.isSubField() ? this.rootFieldName + FlatObjectFieldMapper.VALUE_AND_PATH_SUFFIX : this.name() + FlatObjectFieldMapper.VALUE_SUFFIX;
        }

        public String rewriteSearchValue(Object value) {
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return this.isSubField() ? FlatObjectFieldMapper.getPathPrefix(this.name()) + String.valueOf(value) : value.toString();
        }

        boolean isSubField() {
            return this.rootFieldName != null;
        }

        @Override
        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, boolean caseInsensitive, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            return this.valueFieldType().prefixQuery(this.rewriteSearchValue(value), method, caseInsensitive, context);
        }

        @Override
        public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            return this.valueFieldType().regexpQuery(this.rewriteSearchValue(value), syntaxFlags, matchFlags, maxDeterminizedStates, method, context);
        }

        @Override
        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            return this.valueFieldType().fuzzyQuery(this.rewriteSearchValue(value), fuzziness, prefixLength, maxExpansions, transpositions, method, context);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            if (!context.allowExpensiveQueries()) {
                throw new OpenSearchException("[range] queries on [text] or [keyword] fields cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
            }
            this.failIfNotIndexedAndNoDocValues();
            if (lowerTerm != null && upperTerm != null) {
                return this.valueFieldType().rangeQuery(this.rewriteSearchValue(lowerTerm), this.rewriteSearchValue(upperTerm), includeLower, includeUpper, context);
            }
            IndexOrDocValuesQuery indexQuery = null;
            IndexOrDocValuesQuery dvQuery = null;
            if (this.isSearchable()) {
                if (!this.isSubField()) {
                    indexQuery = new TermRangeQuery(this.getSearchField(), lowerTerm == null ? null : this.indexedValueForSearch(lowerTerm), upperTerm == null ? null : this.indexedValueForSearch(upperTerm), includeLower, includeUpper);
                } else {
                    Automaton a1 = PrefixQuery.toAutomaton((BytesRef)this.indexedValueForSearch(FlatObjectFieldMapper.getPathPrefix(this.name())));
                    BytesRef lowerTermBytes = lowerTerm == null ? null : this.indexedValueForSearch(this.rewriteSearchValue(lowerTerm));
                    BytesRef upperTermBytes = upperTerm == null ? null : this.indexedValueForSearch(this.rewriteSearchValue(upperTerm));
                    Automaton a2 = TermRangeQuery.toAutomaton((BytesRef)lowerTermBytes, (BytesRef)upperTermBytes, (boolean)includeLower, (boolean)includeUpper);
                    Automaton termAutomaton = Operations.intersection((Automaton)a1, (Automaton)a2);
                    indexQuery = new AutomatonQuery(new Term(this.getSearchField()), termAutomaton, 10000, true);
                }
            }
            if (this.hasDocValues()) {
                String dvPrefix = this.isSubField() ? FlatObjectFieldMapper.getDVPrefix(this.rootFieldName) : FlatObjectFieldMapper.getDVPrefix(this.name());
                String prefix = dvPrefix + (this.isSubField() ? FlatObjectFieldMapper.getPathPrefix(this.name()) : "");
                Automaton a1 = PrefixQuery.toAutomaton((BytesRef)this.indexedValueForSearch(prefix));
                BytesRef lowerDvBytes = lowerTerm == null ? null : this.indexedValueForSearch(dvPrefix + this.rewriteSearchValue(lowerTerm));
                BytesRef upperDvBytes = upperTerm == null ? null : this.indexedValueForSearch(dvPrefix + this.rewriteSearchValue(upperTerm));
                Automaton a2 = TermRangeQuery.toAutomaton((BytesRef)lowerDvBytes, (BytesRef)upperDvBytes, (boolean)includeLower, (boolean)includeUpper);
                Automaton dvAutomaton = Operations.intersection((Automaton)a1, (Automaton)a2);
                dvQuery = new AutomatonQuery(new Term(this.getSearchField()), dvAutomaton, 10000, true, MultiTermQuery.DOC_VALUES_REWRITE);
            }
            assert (indexQuery != null || dvQuery != null);
            return indexQuery == null ? dvQuery : (dvQuery == null ? indexQuery : new IndexOrDocValuesQuery((Query)indexQuery, (Query)dvQuery));
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            String searchField;
            String searchKey;
            if (this.isSubField()) {
                searchKey = this.rootFieldName;
                searchField = this.name();
            } else {
                if (this.hasDocValues()) {
                    return new FieldExistsQuery(this.name());
                }
                searchKey = "_field_names";
                searchField = this.name();
            }
            return new TermQuery(new Term(searchKey, this.indexedValueForSearch(searchField)));
        }

        @Override
        public Query wildcardQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, boolean caseInsensitve, QueryShardContext context) {
            this.failIfNotIndexedAndNoDocValues();
            return this.valueFieldType().wildcardQuery(this.rewriteSearchValue(value), method, caseInsensitve, context);
        }

        public class FlatObjectDocValueFormat
        implements DocValueFormat {
            private static final String NAME = "flat_object";
            private final String prefix;

            public FlatObjectDocValueFormat(String prefix) {
                this.prefix = prefix;
            }

            public String getWriteableName() {
                return "flat_object";
            }

            public void writeTo(StreamOutput out) {
            }

            @Override
            public Object format(BytesRef value) {
                String parsedValue = value.utf8ToString();
                if (!parsedValue.startsWith(this.prefix)) {
                    return DOC_VALUE_NO_MATCH;
                }
                return parsedValue.substring(this.prefix.length());
            }

            @Override
            public BytesRef parseBytesRef(String value) {
                return new BytesRef((CharSequence)((String)FlatObjectFieldType.this.valueFieldType.rewriteForDocValue(FlatObjectFieldType.this.rewriteSearchValue(value))));
            }
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder> {
        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        @Override
        public FlatObjectFieldMapper build(Mapper.BuilderContext context) {
            boolean isSearchable = true;
            boolean hasDocValue = true;
            KeywordFieldMapper.KeywordFieldType valueFieldType = FlatObjectFieldType.getKeywordFieldType(this.buildFullName(context), FlatObjectFieldMapper.VALUE_SUFFIX, isSearchable, hasDocValue);
            KeywordFieldMapper.KeywordFieldType valueAndPathFieldType = FlatObjectFieldType.getKeywordFieldType(this.buildFullName(context), FlatObjectFieldMapper.VALUE_AND_PATH_SUFFIX, isSearchable, hasDocValue);
            FlatObjectFieldType fft = new FlatObjectFieldType(this.buildFullName(context), null, valueFieldType, valueAndPathFieldType);
            return new FlatObjectFieldMapper(this.name, Defaults.FIELD_TYPE, fft);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        private final BiFunction<String, Mapper.TypeParser.ParserContext, Builder> builderFunction;

        public TypeParser(BiFunction<String, Mapper.TypeParser.ParserContext, Builder> builderFunction) {
            this.builderFunction = builderFunction;
        }

        @Override
        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            return this.builderFunction.apply(name, parserContext);
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
        }
    }
}

