/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.opensearch.Version;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

@PublicApi(since="1.0.0")
public class ClusterStatsRequest
extends BaseNodesRequest<ClusterStatsRequest> {
    private final Set<Metric> requestedMetrics = new HashSet<Metric>();
    private final Set<IndexMetric> indexMetricsRequested = new HashSet<IndexMetric>();
    private Boolean computeAllMetrics = true;
    private Boolean useAggregatedNodeLevelResponses = false;

    public ClusterStatsRequest(StreamInput in) throws IOException {
        super(in);
        if (in.getVersion().onOrAfter(Version.V_2_16_0)) {
            this.useAggregatedNodeLevelResponses = in.readOptionalBoolean();
        }
        if (in.getVersion().onOrAfter(Version.V_2_18_0)) {
            this.computeAllMetrics = in.readOptionalBoolean();
            long longMetricsFlags = in.readLong();
            for (Metric metric : Metric.values()) {
                if ((longMetricsFlags & (long)(1 << metric.getIndex())) == 0L) continue;
                this.requestedMetrics.add(metric);
            }
            long longIndexMetricFlags = in.readLong();
            for (IndexMetric indexMetric : IndexMetric.values()) {
                if ((longIndexMetricFlags & (long)(1 << indexMetric.getIndex())) == 0L) continue;
                this.indexMetricsRequested.add(indexMetric);
            }
        }
    }

    public ClusterStatsRequest(String ... nodesIds) {
        super(false, nodesIds);
    }

    public boolean useAggregatedNodeLevelResponses() {
        return this.useAggregatedNodeLevelResponses;
    }

    public void useAggregatedNodeLevelResponses(boolean useAggregatedNodeLevelResponses) {
        this.useAggregatedNodeLevelResponses = useAggregatedNodeLevelResponses;
    }

    public boolean computeAllMetrics() {
        return this.computeAllMetrics;
    }

    public void computeAllMetrics(boolean computeAllMetrics) {
        this.computeAllMetrics = computeAllMetrics;
    }

    public ClusterStatsRequest addMetric(Metric metric) {
        this.requestedMetrics.add(metric);
        return this;
    }

    public Set<Metric> requestedMetrics() {
        return new HashSet<Metric>(this.requestedMetrics);
    }

    public ClusterStatsRequest addIndexMetric(IndexMetric indexMetric) {
        this.indexMetricsRequested.add(indexMetric);
        return this;
    }

    public Set<IndexMetric> indicesMetrics() {
        return new HashSet<IndexMetric>(this.indexMetricsRequested);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_2_16_0)) {
            out.writeOptionalBoolean(this.useAggregatedNodeLevelResponses);
        }
        if (out.getVersion().onOrAfter(Version.V_2_18_0)) {
            out.writeOptionalBoolean(this.computeAllMetrics);
            long longMetricFlags = 0L;
            for (Metric metric : this.requestedMetrics) {
                longMetricFlags |= (long)(1 << metric.getIndex());
            }
            out.writeLong(longMetricFlags);
            long longIndexMetricFlags = 0L;
            for (IndexMetric indexMetric : this.indexMetricsRequested) {
                longIndexMetricFlags |= (long)(1 << indexMetric.getIndex());
            }
            out.writeLong(longIndexMetricFlags);
        }
    }

    @PublicApi(since="2.18.0")
    public static enum Metric {
        OS("os", 0),
        JVM("jvm", 1),
        FS("fs", 2),
        PROCESS("process", 3),
        INGEST("ingest", 4),
        PLUGINS("plugins", 5),
        NETWORK_TYPES("network_types", 6),
        DISCOVERY_TYPES("discovery_types", 7),
        PACKAGING_TYPES("packaging_types", 8),
        INDICES("indices", 9);

        private String metricName;
        private int index;

        private Metric(String name, int index) {
            this.metricName = name;
            this.index = index;
        }

        public String metricName() {
            return this.metricName;
        }

        public int getIndex() {
            return this.index;
        }
    }

    @PublicApi(since="2.18.0")
    public static enum IndexMetric {
        SHARDS("shards", 0),
        DOCS("docs", 1),
        STORE("store", 2),
        FIELDDATA("fielddata", 3),
        QUERY_CACHE("query_cache", 4),
        COMPLETION("completion", 5),
        SEGMENTS("segments", 6),
        ANALYSIS("analysis", 7),
        MAPPINGS("mappings", 8);

        private String metricName;
        private int index;

        private IndexMetric(String name, int index) {
            this.metricName = name;
            this.index = index;
        }

        public String metricName() {
            return this.metricName;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

