/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.state;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.unit.ByteSizeValue;

@PublicApi(since="1.0.0")
public class ClusterStateResponse
extends ActionResponse {
    private ClusterName clusterName;
    private ClusterState clusterState;
    private boolean waitForTimedOut = false;

    public ClusterStateResponse(StreamInput in) throws IOException {
        super(in);
        this.clusterName = new ClusterName(in);
        this.clusterState = (ClusterState)in.readOptionalWriteable(innerIn -> ClusterState.readFrom(innerIn, null));
        if (in.getVersion().before((Version)LegacyESVersion.V_7_0_0)) {
            new ByteSizeValue(in);
        }
        this.waitForTimedOut = in.readBoolean();
    }

    public ClusterStateResponse(ClusterName clusterName, ClusterState clusterState, boolean waitForTimedOut) {
        this.clusterName = clusterName;
        this.clusterState = clusterState;
        this.waitForTimedOut = waitForTimedOut;
    }

    public ClusterState getState() {
        return this.clusterState;
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public boolean isWaitForTimedOut() {
        return this.waitForTimedOut;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.clusterName.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.clusterState);
        if (out.getVersion().before((Version)LegacyESVersion.V_7_0_0)) {
            ByteSizeValue.ZERO.writeTo(out);
        }
        out.writeBoolean(this.waitForTimedOut);
    }

    public String toString() {
        return "ClusterStateResponse{clusterState=" + String.valueOf(this.clusterState) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ClusterStateResponse response = (ClusterStateResponse)((Object)o);
        return this.waitForTimedOut == response.waitForTimedOut && Objects.equals(this.clusterName, response.clusterName) && Objects.equals(ClusterStateResponse.getVersion(this.clusterState), ClusterStateResponse.getVersion(response.clusterState)) && Objects.equals(ClusterStateResponse.getClusterManagerNodeId(this.clusterState), ClusterStateResponse.getClusterManagerNodeId(response.clusterState));
    }

    public int hashCode() {
        return Objects.hash(this.clusterName, ClusterStateResponse.getVersion(this.clusterState), ClusterStateResponse.getClusterManagerNodeId(this.clusterState), this.waitForTimedOut);
    }

    private static String getClusterManagerNodeId(ClusterState clusterState) {
        if (clusterState == null) {
            return null;
        }
        DiscoveryNodes nodes = clusterState.getNodes();
        if (nodes != null) {
            return nodes.getClusterManagerNodeId();
        }
        return null;
    }

    private static Long getVersion(ClusterState clusterState) {
        if (clusterState != null) {
            return clusterState.getVersion();
        }
        return null;
    }
}

