/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.SuppressForbidden;

@SuppressForbidden(reason="Taken from Lucene")
public final class SPIClassIterator<S>
implements Iterator<Class<? extends S>> {
    private static final String META_INF_SERVICES = "META-INF/services/";
    private final Class<S> clazz;
    private final ClassLoader loader;
    private final Enumeration<URL> profilesEnum;
    private Iterator<String> linesIterator;

    public static <S> SPIClassIterator<S> get(Class<S> clazz) {
        return new SPIClassIterator<S>(clazz, Objects.requireNonNull(clazz.getClassLoader(), () -> String.valueOf(clazz) + " has no classloader."));
    }

    public static <S> SPIClassIterator<S> get(Class<S> clazz, ClassLoader loader) {
        return new SPIClassIterator<S>(clazz, loader);
    }

    public static boolean isParentClassLoader(ClassLoader parent, ClassLoader child) {
        try {
            for (ClassLoader cl = child; cl != null; cl = cl.getParent()) {
                if (cl != parent) continue;
                return true;
            }
            return false;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    private SPIClassIterator(Class<S> clazz, ClassLoader loader) {
        this.clazz = Objects.requireNonNull(clazz, "clazz");
        this.loader = Objects.requireNonNull(loader, "loader");
        try {
            String fullName = META_INF_SERVICES + clazz.getName();
            this.profilesEnum = loader.getResources(fullName);
        }
        catch (IOException ioe) {
            throw new ServiceConfigurationError("Error loading SPI profiles for type " + clazz.getName() + " from classpath", ioe);
        }
        this.linesIterator = Collections.emptySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadNextProfile() {
        ArrayList<String> lines = null;
        while (this.profilesEnum.hasMoreElements()) {
            block12: {
                if (lines != null) {
                    lines.clear();
                } else {
                    lines = new ArrayList<String>();
                }
                URL url = this.profilesEnum.nextElement();
                try {
                    InputStream in;
                    block11: {
                        in = url.openStream();
                        boolean success = false;
                        try {
                            String line;
                            BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                            while ((line = reader.readLine()) != null) {
                                int pos = line.indexOf(35);
                                if (pos >= 0) {
                                    line = line.substring(0, pos);
                                }
                                if ((line = line.trim()).length() <= 0) continue;
                                lines.add(line);
                            }
                            success = true;
                            if (!success) break block11;
                        }
                        catch (Throwable throwable) {
                            if (success) {
                                IOUtils.close((Closeable[])new Closeable[]{in});
                            } else {
                                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                            }
                            throw throwable;
                        }
                        IOUtils.close((Closeable[])new Closeable[]{in});
                        break block12;
                    }
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                }
                catch (IOException ioe) {
                    throw new ServiceConfigurationError("Error loading SPI class list from URL: " + String.valueOf(url), ioe);
                }
            }
            if (lines.isEmpty()) continue;
            this.linesIterator = lines.iterator();
            return true;
        }
        return false;
    }

    @Override
    public boolean hasNext() {
        return this.linesIterator.hasNext() || this.loadNextProfile();
    }

    @Override
    public Class<? extends S> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        assert (this.linesIterator.hasNext());
        String c = this.linesIterator.next();
        try {
            return Class.forName(c, false, this.loader).asSubclass(this.clazz);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ServiceConfigurationError(String.format(Locale.ROOT, "An SPI class of type %s with classname %s does not exist, please fix the file '%s%1$s' in your classpath.", this.clazz.getName(), c, META_INF_SERVICES));
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

