/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.common;

import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;

public class FlowFrameworkSettings {
    private volatile Boolean isFlowFrameworkEnabled;
    private volatile TimeValue retryDuration;
    private volatile Integer maxWorkflowSteps;
    protected volatile Integer maxWorkflows;
    protected volatile TimeValue requestTimeout;
    private final Boolean isMultiTenancyEnabled;
    public static final int MAX_WORKFLOWS_LIMIT = 10000;
    public static final int MAX_WORKFLOW_STEPS_LIMIT = 500;
    public static final Setting<Integer> MAX_WORKFLOWS = Setting.intSetting((String)"plugins.flow_framework.max_workflows", (int)1000, (int)0, (int)10000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Integer> MAX_WORKFLOW_STEPS = Setting.intSetting((String)"plugins.flow_framework.max_workflow_steps", (int)50, (int)1, (int)500, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> WORKFLOW_REQUEST_TIMEOUT = Setting.positiveTimeSetting((String)"plugins.flow_framework.request_timeout", (TimeValue)TimeValue.timeValueSeconds((long)10L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> FLOW_FRAMEWORK_ENABLED = Setting.boolSetting((String)"plugins.flow_framework.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> TASK_REQUEST_RETRY_DURATION = Setting.positiveTimeSetting((String)"plugins.flow_framework.task_request_retry_duration", (TimeValue)TimeValue.timeValueSeconds((long)5L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> FILTER_BY_BACKEND_ROLES = Setting.boolSetting((String)"plugins.flow_framework.filter_by_backend_roles", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Boolean> FLOW_FRAMEWORK_MULTI_TENANCY_ENABLED = Setting.boolSetting((String)"plugins.flow_framework.multi_tenancy_enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> REMOTE_METADATA_TYPE = Setting.simpleString((String)"plugins.flow_framework.remote_metadata_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final});
    public static final Setting<String> REMOTE_METADATA_ENDPOINT = Setting.simpleString((String)"plugins.flow_framework.remote_metadata_endpoint", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final});
    public static final Setting<String> REMOTE_METADATA_REGION = Setting.simpleString((String)"plugins.flow_framework.remote_metadata_region", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final});
    public static final Setting<String> REMOTE_METADATA_SERVICE_NAME = Setting.simpleString((String)"plugins.flow_framework.remote_metadata_service_name", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final});

    public FlowFrameworkSettings(ClusterService clusterService, Settings settings) {
        this.isFlowFrameworkEnabled = (Boolean)FLOW_FRAMEWORK_ENABLED.get(settings);
        this.retryDuration = (TimeValue)TASK_REQUEST_RETRY_DURATION.get(settings);
        this.maxWorkflowSteps = (Integer)MAX_WORKFLOW_STEPS.get(settings);
        this.maxWorkflows = (Integer)MAX_WORKFLOWS.get(settings);
        this.requestTimeout = (TimeValue)WORKFLOW_REQUEST_TIMEOUT.get(settings);
        this.isMultiTenancyEnabled = (Boolean)FLOW_FRAMEWORK_MULTI_TENANCY_ENABLED.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(FLOW_FRAMEWORK_ENABLED, it -> {
            this.isFlowFrameworkEnabled = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(TASK_REQUEST_RETRY_DURATION, it -> {
            this.retryDuration = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_WORKFLOW_STEPS, it -> {
            this.maxWorkflowSteps = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_WORKFLOWS, it -> {
            this.maxWorkflows = it;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(WORKFLOW_REQUEST_TIMEOUT, it -> {
            this.requestTimeout = it;
        });
    }

    public boolean isFlowFrameworkEnabled() {
        return this.isFlowFrameworkEnabled;
    }

    public TimeValue getRetryDuration() {
        return this.retryDuration;
    }

    public Integer getMaxWorkflowSteps() {
        return this.maxWorkflowSteps;
    }

    public Integer getMaxWorkflows() {
        return this.maxWorkflows;
    }

    public TimeValue getRequestTimeout() {
        return this.requestTimeout;
    }

    public boolean isMultiTenancyEnabled() {
        return this.isMultiTenancyEnabled;
    }
}

