/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.resthandler;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.securityanalytics.action.DeleteRuleAction;
import org.opensearch.securityanalytics.action.DeleteRuleRequest;

public class RestDeleteRuleAction
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(RestDeleteRuleAction.class);

    public String getName() {
        return "delete_rule_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.DELETE, String.format(Locale.getDefault(), "%s/{ruleID}", "/_plugins/_security_analytics/rules")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        log.debug(String.format(Locale.getDefault(), "%s %s/{ruleID}", request.method(), "/_plugins/_security_analytics/rules"));
        String ruleID = request.param("ruleID");
        Boolean forced = request.paramAsBoolean("forced", false);
        WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.parse((String)request.param("refresh", WriteRequest.RefreshPolicy.IMMEDIATE.getValue()));
        DeleteRuleRequest deleteRuleRequest = new DeleteRuleRequest(ruleID, refreshPolicy, forced);
        return channel -> client.execute((ActionType)DeleteRuleAction.INSTANCE, (ActionRequest)deleteRuleRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

