/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.monitor;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpenSearchMemoryHealthy {
    @Generated
    private static final Logger log = LogManager.getLogger(OpenSearchMemoryHealthy.class);
    private final RandomFail randomFail;
    private final MemoryUsage memoryUsage;

    public OpenSearchMemoryHealthy() {
        this.randomFail = new RandomFail();
        this.memoryUsage = new MemoryUsage();
    }

    @VisibleForTesting
    public OpenSearchMemoryHealthy(RandomFail randomFail, MemoryUsage memoryUsage) {
        this.randomFail = randomFail;
        this.memoryUsage = memoryUsage;
    }

    public boolean isMemoryHealthy(long limitBytes) {
        long memoryUsage = this.memoryUsage.usage();
        log.debug("Memory usage:{}, limit:{}", (Object)memoryUsage, (Object)limitBytes);
        if (memoryUsage < limitBytes) {
            return true;
        }
        log.warn("Memory usage:{} exceed limit:{}", (Object)memoryUsage, (Object)limitBytes);
        if (this.randomFail.shouldFail()) {
            log.warn("Fast failing the current request");
            throw new MemoryUsageExceedFastFailureException();
        }
        throw new MemoryUsageExceedException();
    }

    static class RandomFail {
        RandomFail() {
        }

        public boolean shouldFail() {
            return ThreadLocalRandom.current().nextBoolean();
        }
    }

    static class MemoryUsage {
        MemoryUsage() {
        }

        public long usage() {
            long freeMemory = Runtime.getRuntime().freeMemory();
            long totalMemory = Runtime.getRuntime().totalMemory();
            return totalMemory - freeMemory;
        }
    }

    public static class MemoryUsageExceedFastFailureException
    extends RuntimeException {
        @Generated
        public MemoryUsageExceedFastFailureException() {
        }
    }

    public static class MemoryUsageExceedException
    extends RuntimeException {
        @Generated
        public MemoryUsageExceedException() {
        }
    }
}

