/*
 * Decompiled with CFR 0.152.
 */
package com.intel.qat;

import com.intel.qat.QatZipper;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;

public class QatCompressorOutputStream
extends FilterOutputStream {
    private byte[] inputBuffer;
    private int inputPosition;
    private QatZipper qzip;
    private byte[] outputBuffer;
    private int outputPosition;
    private boolean closed;
    public static final int DEFAULT_BUFFER_SIZE = 65536;

    public QatCompressorOutputStream(OutputStream out, int bufferSize, QatZipper.Algorithm algorithm, int level, QatZipper.Mode mode, QatZipper.PollingMode pmode) {
        super(out);
        if (bufferSize <= 0) {
            throw new IllegalArgumentException();
        }
        Objects.requireNonNull(out);
        this.qzip = new QatZipper(algorithm, level, mode, pmode);
        this.inputBuffer = new byte[bufferSize];
        this.outputBuffer = new byte[this.qzip.maxCompressedLength(bufferSize)];
        this.closed = false;
    }

    public QatCompressorOutputStream(OutputStream out) {
        this(out, 65536, QatZipper.Algorithm.DEFLATE, 6, QatZipper.DEFAULT_MODE, QatZipper.PollingMode.BUSY);
    }

    public QatCompressorOutputStream(OutputStream out, int bufferSize) {
        this(out, bufferSize, QatZipper.Algorithm.DEFLATE, 6, QatZipper.DEFAULT_MODE, QatZipper.PollingMode.BUSY);
    }

    public QatCompressorOutputStream(OutputStream out, int bufferSize, QatZipper.Algorithm algorithm) {
        this(out, bufferSize, algorithm, 6, QatZipper.DEFAULT_MODE, QatZipper.PollingMode.BUSY);
    }

    public QatCompressorOutputStream(OutputStream out, int bufferSize, QatZipper.Mode mode) {
        this(out, bufferSize, QatZipper.Algorithm.DEFLATE, 6, mode, QatZipper.PollingMode.BUSY);
    }

    public QatCompressorOutputStream(OutputStream out, int bufferSize, QatZipper.PollingMode pmode) {
        this(out, bufferSize, QatZipper.Algorithm.DEFLATE, 6, QatZipper.DEFAULT_MODE, pmode);
    }

    public QatCompressorOutputStream(OutputStream out, int bufferSize, QatZipper.Algorithm algorithm, int level) {
        this(out, bufferSize, algorithm, level, QatZipper.DEFAULT_MODE, QatZipper.PollingMode.BUSY);
    }

    public QatCompressorOutputStream(OutputStream out, int bufferSize, QatZipper.Algorithm algorithm, QatZipper.Mode mode) {
        this(out, bufferSize, algorithm, 6, mode, QatZipper.PollingMode.BUSY);
    }

    public QatCompressorOutputStream(OutputStream out, int bufferSize, QatZipper.Algorithm algorithm, QatZipper.PollingMode pmode) {
        this(out, bufferSize, algorithm, 6, QatZipper.DEFAULT_MODE, pmode);
    }

    public QatCompressorOutputStream(OutputStream out, int bufferSize, QatZipper.Algorithm algorithm, int level, QatZipper.Mode mode) {
        this(out, bufferSize, algorithm, level, mode, QatZipper.PollingMode.BUSY);
    }

    public QatCompressorOutputStream(OutputStream out, int bufferSize, QatZipper.Algorithm algorithm, int level, QatZipper.PollingMode pmode) {
        this(out, bufferSize, algorithm, level, QatZipper.DEFAULT_MODE, pmode);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.inputPosition == this.inputBuffer.length) {
            this.flush();
        }
        this.inputBuffer[this.inputPosition++] = (byte)b;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        Objects.requireNonNull(b);
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        int bytesToWrite = 0;
        while (len > (bytesToWrite = this.inputBuffer.length - this.inputPosition)) {
            System.arraycopy(b, off, this.inputBuffer, this.inputPosition, bytesToWrite);
            this.inputPosition += bytesToWrite;
            len -= bytesToWrite;
            off += bytesToWrite;
            this.flush();
        }
        System.arraycopy(b, off, this.inputBuffer, this.inputPosition, len);
        this.inputPosition += len;
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.inputPosition == 0) {
            return;
        }
        int currentPosition = this.inputPosition;
        this.inputPosition = 0;
        int compressedBytes = this.qzip.compress(this.inputBuffer, this.inputPosition, currentPosition, this.outputBuffer, this.outputPosition, this.outputBuffer.length - this.outputPosition);
        this.out.write(this.outputBuffer, 0, compressedBytes);
        this.out.flush();
        this.outputPosition = 0;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.flush();
        this.qzip.end();
        this.out.close();
        this.inputBuffer = null;
        this.outputBuffer = null;
        this.closed = true;
    }
}

