/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.controlcenter.notification.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.tasks.TaskId;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.indexmanagement.common.model.notification.Channel;
import org.opensearch.indexmanagement.controlcenter.notification.model.LRONCondition;
import org.opensearch.indexmanagement.controlcenter.notification.util.LRONUtils;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 82\u00020\u00012\u00020\u0002:\u00018B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005BE\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u0011\u0010$\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003J\u0010\u0010&\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001bJZ\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00c6\u0001\u00a2\u0006\u0002\u0010(J\u0013\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u00d6\u0003J\t\u0010-\u001a\u00020\u0012H\u00d6\u0001J\t\u0010.\u001a\u00020\u000bH\u00d6\u0001J\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00069"}, d2={"Lorg/opensearch/indexmanagement/controlcenter/notification/model/LRONConfig;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "Lorg/opensearch/core/common/io/stream/Writeable;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "lronCondition", "Lorg/opensearch/indexmanagement/controlcenter/notification/model/LRONCondition;", "taskId", "Lorg/opensearch/core/tasks/TaskId;", "actionName", "", "channels", "", "Lorg/opensearch/indexmanagement/common/model/notification/Channel;", "user", "Lorg/opensearch/commons/authuser/User;", "priority", "", "(Lorg/opensearch/indexmanagement/controlcenter/notification/model/LRONCondition;Lorg/opensearch/core/tasks/TaskId;Ljava/lang/String;Ljava/util/List;Lorg/opensearch/commons/authuser/User;Ljava/lang/Integer;)V", "getActionName", "()Ljava/lang/String;", "getChannels", "()Ljava/util/List;", "getLronCondition", "()Lorg/opensearch/indexmanagement/controlcenter/notification/model/LRONCondition;", "getPriority", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getTaskId", "()Lorg/opensearch/core/tasks/TaskId;", "getUser", "()Lorg/opensearch/commons/authuser/User;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "(Lorg/opensearch/indexmanagement/controlcenter/notification/model/LRONCondition;Lorg/opensearch/core/tasks/TaskId;Ljava/lang/String;Ljava/util/List;Lorg/opensearch/commons/authuser/User;Ljava/lang/Integer;)Lorg/opensearch/indexmanagement/controlcenter/notification/model/LRONConfig;", "equals", "", "other", "", "hashCode", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nLRONConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LRONConfig.kt\norg/opensearch/indexmanagement/controlcenter/notification/model/LRONConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n1#2:173\n1855#3,2:174\n*S KotlinDebug\n*F\n+ 1 LRONConfig.kt\norg/opensearch/indexmanagement/controlcenter/notification/model/LRONConfig\n*L\n55#1:174,2\n*E\n"})
public final class LRONConfig
implements ToXContentObject,
Writeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LRONCondition lronCondition;
    @Nullable
    private final TaskId taskId;
    @Nullable
    private final String actionName;
    @Nullable
    private final List<Channel> channels;
    @Nullable
    private final User user;
    @Nullable
    private final Integer priority;
    @NotNull
    public static final String LRON_CONFIG_FIELD = "lron_config";
    @NotNull
    public static final String LRON_CONFIG_FIELDS = "lron_configs";
    @NotNull
    public static final String TASK_ID_FIELD = "task_id";
    @NotNull
    public static final String ACTION_NAME_FIELD = "action_name";
    @NotNull
    public static final String CHANNELS_FIELD = "channels";
    @NotNull
    public static final String USER_FIELD = "user";
    @NotNull
    public static final String PRIORITY_FIELD = "priority";
    @NotNull
    public static final String CHANNEL_TITLE = "Long Running Operation Notification";

    public LRONConfig(@NotNull LRONCondition lronCondition, @Nullable TaskId taskId, @Nullable String actionName, @Nullable List<Channel> channels, @Nullable User user, @Nullable Integer priority) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)lronCondition, (String)"lronCondition");
        this.lronCondition = lronCondition;
        this.taskId = taskId;
        this.actionName = actionName;
        this.channels = channels;
        this.user = user;
        this.priority = priority;
        LRONUtils.validateTaskIdAndActionName(this.taskId, this.actionName);
        if (this.lronCondition.isEnabled() && !(!((collection = (Collection)this.channels) == null || collection.isEmpty()))) {
            boolean bl = false;
            String string = "Enabled LRONConfig must contain at least one channel";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final LRONCondition getLronCondition() {
        return this.lronCondition;
    }

    @Nullable
    public final TaskId getTaskId() {
        return this.taskId;
    }

    @Nullable
    public final String getActionName() {
        return this.actionName;
    }

    @Nullable
    public final List<Channel> getChannels() {
        return this.channels;
    }

    @Nullable
    public final User getUser() {
        return this.user;
    }

    @Nullable
    public final Integer getPriority() {
        return this.priority;
    }

    @NotNull
    public final XContentBuilder toXContent(@NotNull XContentBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        ToXContent.Params params = ToXContent.EMPTY_PARAMS;
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"EMPTY_PARAMS");
        return this.toXContent(builder, params);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject();
        if (params.paramAsBoolean("with_type", true)) {
            builder.startObject(LRON_CONFIG_FIELD);
        }
        builder.field("lron_condition", (ToXContent)this.lronCondition);
        if (this.taskId != null) {
            builder.field(TASK_ID_FIELD, this.taskId.toString());
        }
        if (this.actionName != null) {
            builder.field(ACTION_NAME_FIELD, this.actionName);
        }
        if (params.paramAsBoolean("with_user", true)) {
            OpenSearchExtensionsKt.optionalUserField(builder, USER_FIELD, this.user);
        }
        if (this.channels != null) {
            XContentBuilder xContentBuilder;
            XContentBuilder it = xContentBuilder = builder.startArray(CHANNELS_FIELD);
            boolean bl = false;
            Iterable $this$forEach$iv = this.channels;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Channel channel = (Channel)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                channel.toXContent(it, params);
            }
            xContentBuilder.endArray();
        }
        if (params.paramAsBoolean("with_priority", true)) {
            builder.field(PRIORITY_FIELD, this.priority);
        }
        if (params.paramAsBoolean("with_type", true)) {
            builder.endObject();
        }
        XContentBuilder xContentBuilder = builder.endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.endObject()");
        return xContentBuilder;
    }

    public LRONConfig(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        this(new LRONCondition(sin), sin.readBoolean() ? new TaskId(sin.readString()) : null, sin.readOptionalString(), sin.readBoolean() ? sin.readList(Channel::new) : null, (User)sin.readOptionalWriteable(User::new), sin.readOptionalInt());
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.lronCondition.writeTo(out);
        if (this.taskId != null) {
            out.writeBoolean(true);
            out.writeString(this.taskId.toString());
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.actionName);
        if (this.channels != null) {
            out.writeBoolean(true);
            out.writeList(this.channels);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalWriteable((Writeable)this.user);
        out.writeOptionalInt(this.priority);
    }

    @NotNull
    public final LRONCondition component1() {
        return this.lronCondition;
    }

    @Nullable
    public final TaskId component2() {
        return this.taskId;
    }

    @Nullable
    public final String component3() {
        return this.actionName;
    }

    @Nullable
    public final List<Channel> component4() {
        return this.channels;
    }

    @Nullable
    public final User component5() {
        return this.user;
    }

    @Nullable
    public final Integer component6() {
        return this.priority;
    }

    @NotNull
    public final LRONConfig copy(@NotNull LRONCondition lronCondition, @Nullable TaskId taskId, @Nullable String actionName, @Nullable List<Channel> channels, @Nullable User user, @Nullable Integer priority) {
        Intrinsics.checkNotNullParameter((Object)lronCondition, (String)"lronCondition");
        return new LRONConfig(lronCondition, taskId, actionName, channels, user, priority);
    }

    public static /* synthetic */ LRONConfig copy$default(LRONConfig lRONConfig, LRONCondition lRONCondition, TaskId taskId, String string, List list, User user, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            lRONCondition = lRONConfig.lronCondition;
        }
        if ((n2 & 2) != 0) {
            taskId = lRONConfig.taskId;
        }
        if ((n2 & 4) != 0) {
            string = lRONConfig.actionName;
        }
        if ((n2 & 8) != 0) {
            list = lRONConfig.channels;
        }
        if ((n2 & 0x10) != 0) {
            user = lRONConfig.user;
        }
        if ((n2 & 0x20) != 0) {
            n = lRONConfig.priority;
        }
        return lRONConfig.copy(lRONCondition, taskId, string, list, user, n);
    }

    @NotNull
    public String toString() {
        return "LRONConfig(lronCondition=" + this.lronCondition + ", taskId=" + this.taskId + ", actionName=" + this.actionName + ", channels=" + this.channels + ", user=" + this.user + ", priority=" + this.priority + ")";
    }

    public int hashCode() {
        int result2 = this.lronCondition.hashCode();
        result2 = result2 * 31 + (this.taskId == null ? 0 : this.taskId.hashCode());
        result2 = result2 * 31 + (this.actionName == null ? 0 : this.actionName.hashCode());
        result2 = result2 * 31 + (this.channels == null ? 0 : ((Object)this.channels).hashCode());
        result2 = result2 * 31 + (this.user == null ? 0 : this.user.hashCode());
        result2 = result2 * 31 + (this.priority == null ? 0 : ((Object)this.priority).hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LRONConfig)) {
            return false;
        }
        LRONConfig lRONConfig = (LRONConfig)other;
        if (!Intrinsics.areEqual((Object)this.lronCondition, (Object)lRONConfig.lronCondition)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.taskId, (Object)lRONConfig.taskId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.actionName, (Object)lRONConfig.actionName)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.channels, lRONConfig.channels)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.user, (Object)lRONConfig.user)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.priority, (Object)lRONConfig.priority);
    }

    @JvmStatic
    @NotNull
    public static final LRONConfig parse(@NotNull XContentParser xcp, @NotNull String id2, long seqNo, long primaryTerm) throws IOException {
        return Companion.parse(xcp, id2, seqNo, primaryTerm);
    }

    @JvmStatic
    @NotNull
    public static final LRONConfig parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J.\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0012H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/opensearch/indexmanagement/controlcenter/notification/model/LRONConfig$Companion;", "", "()V", "ACTION_NAME_FIELD", "", "CHANNELS_FIELD", "CHANNEL_TITLE", "LRON_CONFIG_FIELD", "LRON_CONFIG_FIELDS", "PRIORITY_FIELD", "TASK_ID_FIELD", "USER_FIELD", "parse", "Lorg/opensearch/indexmanagement/controlcenter/notification/model/LRONConfig;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "id", "seqNo", "", "primaryTerm", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LRONConfig parse(@NotNull XContentParser xcp, @NotNull String id2, long seqNo, long primaryTerm) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            return this.parse(xcp);
        }

        public static /* synthetic */ LRONConfig parse$default(Companion companion, XContentParser xContentParser, String string, long l, long l2, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                l = -2L;
            }
            if ((n & 8) != 0) {
                l2 = 0L;
            }
            return companion.parse(xContentParser, string, l, l2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        @NotNull
        public final LRONConfig parse(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            LRONCondition lronCondition = new LRONCondition(false, false, 3, null);
            TaskId taskId = null;
            String actionName = null;
            List channels = null;
            User user = null;
            Integer priority = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block8: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName;
                block16: {
                    block17: {
                        block14: {
                            block15: {
                                fieldName = xcp.currentName();
                                xcp.nextToken();
                                String string = fieldName;
                                if (string == null) throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in LRONConfig.");
                                switch (string.hashCode()) {
                                    case 1432626128: {
                                        if (!string.equals(LRONConfig.CHANNELS_FIELD)) {
                                            throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in LRONConfig.");
                                        }
                                        break block14;
                                    }
                                    case 1583556340: {
                                        if (!string.equals(LRONConfig.ACTION_NAME_FIELD)) {
                                            throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in LRONConfig.");
                                        }
                                        break block15;
                                    }
                                    case -1537240555: {
                                        if (string.equals(LRONConfig.TASK_ID_FIELD)) break;
                                        throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in LRONConfig.");
                                    }
                                    case -1165461084: {
                                        if (!string.equals(LRONConfig.PRIORITY_FIELD)) {
                                            throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in LRONConfig.");
                                        }
                                        break block16;
                                    }
                                    case 3599307: {
                                        if (!string.equals(LRONConfig.USER_FIELD)) {
                                            throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in LRONConfig.");
                                        }
                                        break block17;
                                    }
                                    case 1142939457: {
                                        if (!string.equals("lron_condition")) throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in LRONConfig.");
                                        lronCondition = LRONCondition.Companion.parse(xcp);
                                        continue block8;
                                    }
                                }
                                taskId = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : new TaskId(xcp.text());
                                continue;
                            }
                            actionName = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : xcp.text();
                            continue;
                        }
                        if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        channels = new ArrayList();
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                        while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                            channels.add(Channel.Companion.parse(xcp));
                        }
                        continue;
                    }
                    user = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : User.parse((XContentParser)xcp);
                    continue;
                }
                priority = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : Integer.valueOf(xcp.intValue());
                continue;
                throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in LRONConfig.");
            }
            return new LRONConfig(lronCondition, taskId, actionName, channels, user, priority);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

