/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.action;

import com.o19s.es.ltr.action.AddFeaturesToSetAction;
import com.o19s.es.ltr.action.FeatureStoreAction;
import com.o19s.es.ltr.action.TransportFeatureStoreAction;
import com.o19s.es.ltr.feature.FeatureValidation;
import com.o19s.es.ltr.feature.store.StorableElement;
import com.o19s.es.ltr.feature.store.StoredFeature;
import com.o19s.es.ltr.feature.store.StoredFeatureSet;
import com.o19s.es.ltr.feature.store.index.IndexFeatureStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.TransportGetAction;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.TransportSearchAction;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.CountDown;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.ltr.breaker.LTRCircuitBreakerService;
import org.opensearch.ltr.exception.LimitExceededException;
import org.opensearch.search.SearchHit;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportAddFeatureToSetAction
extends HandledTransportAction<AddFeaturesToSetAction.AddFeaturesToSetRequest, AddFeaturesToSetAction.AddFeaturesToSetResponse> {
    private final ClusterService clusterService;
    private final TransportSearchAction searchAction;
    private final TransportGetAction getAction;
    private final TransportFeatureStoreAction featureStoreAction;
    private final LTRCircuitBreakerService ltrCircuitBreakerService;

    @Inject
    public TransportAddFeatureToSetAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, TransportSearchAction searchAction, TransportGetAction getAction, TransportFeatureStoreAction featureStoreAction, LTRCircuitBreakerService ltrCircuitBreakerService) {
        super("cluster:admin/ltr/store/add-features-to-set", transportService, actionFilters, AddFeaturesToSetAction.AddFeaturesToSetRequest::new);
        this.clusterService = clusterService;
        this.searchAction = searchAction;
        this.getAction = getAction;
        this.featureStoreAction = featureStoreAction;
        this.ltrCircuitBreakerService = ltrCircuitBreakerService;
    }

    protected void doExecute(Task task, AddFeaturesToSetAction.AddFeaturesToSetRequest request, ActionListener<AddFeaturesToSetAction.AddFeaturesToSetResponse> listener) {
        if (!this.clusterService.state().routingTable().hasIndex(request.getStore())) {
            throw new IllegalArgumentException("Store [" + request.getStore() + "] does not exist, please create it first.");
        }
        if (this.ltrCircuitBreakerService.isOpen().booleanValue()) {
            throw new LimitExceededException("Store [" + request.getStore() + "] adding feature set is not allowed as memory circuit is broken.");
        }
        new AsyncAction(task, request, listener, this.clusterService, this.searchAction, this.getAction, this.featureStoreAction).start();
    }

    private static class AsyncAction {
        private final Task task;
        private final String store;
        private final ActionListener<AddFeaturesToSetAction.AddFeaturesToSetResponse> listener;
        private final String featureNamesQuery;
        private final List<StoredFeature> features;
        private final boolean merge;
        private final String featureSetName;
        private final String routing;
        private final AtomicReference<Exception> searchException = new AtomicReference();
        private final AtomicReference<Exception> getException = new AtomicReference();
        private final AtomicReference<StoredFeatureSet> setRef = new AtomicReference();
        private final AtomicReference<List<StoredFeature>> featuresRef = new AtomicReference();
        private final CountDown countdown;
        private final AtomicLong version = new AtomicLong(-1L);
        private final ClusterService clusterService;
        private final TransportSearchAction searchAction;
        private final TransportGetAction getAction;
        private final TransportFeatureStoreAction featureStoreAction;
        private final FeatureValidation validation;

        AsyncAction(Task task, AddFeaturesToSetAction.AddFeaturesToSetRequest request, ActionListener<AddFeaturesToSetAction.AddFeaturesToSetResponse> listener, ClusterService clusterService, TransportSearchAction searchAction, TransportGetAction getAction, TransportFeatureStoreAction featureStoreAction) {
            this.task = task;
            this.listener = listener;
            this.featureSetName = request.getFeatureSet();
            this.featureNamesQuery = request.getFeatureNameQuery();
            this.features = request.getFeatures();
            if (this.featureNamesQuery != null) {
                assert (this.features == null || this.features.isEmpty());
                this.countdown = new CountDown(2);
            } else {
                assert (this.features != null && !this.features.isEmpty());
                this.countdown = new CountDown(1);
            }
            this.merge = request.isMerge();
            this.store = request.getStore();
            this.routing = request.getRouting();
            this.clusterService = clusterService;
            this.searchAction = searchAction;
            this.getAction = getAction;
            this.featureStoreAction = featureStoreAction;
            this.validation = request.getValidation();
        }

        private void start() {
            if (this.featureNamesQuery != null) {
                this.fetchFeaturesFromStore();
            } else {
                this.featuresRef.set(this.features);
            }
            GetRequest getRequest = new GetRequest(this.store).id(StorableElement.generateId("featureset", this.featureSetName)).routing(this.routing);
            getRequest.setParentTask(this.clusterService.localNode().getId(), this.task.getId());
            this.getAction.execute((ActionRequest)getRequest, ActionListener.wrap(this::onGetResponse, this::onGetFailure));
        }

        private void fetchFeaturesFromStore() {
            String parsed;
            SearchRequest srequest = new SearchRequest(new String[]{this.store});
            srequest.setParentTask(this.clusterService.localNode().getId(), this.task.getId());
            Object nameQuery = this.featureNamesQuery.endsWith("*") ? ((parsed = this.featureNamesQuery.replaceAll("[*]+$", "")).isEmpty() ? QueryBuilders.matchAllQuery() : QueryBuilders.matchQuery((String)"name.prefix", (Object)parsed)) : QueryBuilders.matchQuery((String)"name", (Object)this.featureNamesQuery);
            BoolQueryBuilder bq = QueryBuilders.boolQuery();
            bq.must((QueryBuilder)nameQuery);
            bq.must((QueryBuilder)QueryBuilders.matchQuery((String)"type", (Object)"feature"));
            srequest.source().query((QueryBuilder)bq);
            srequest.source().fetchSource(true);
            srequest.source().size(10000);
            this.searchAction.execute((ActionRequest)srequest, ActionListener.wrap(this::onSearchResponse, this::onSearchFailure));
        }

        private void onGetFailure(Exception e) {
            this.getException.set(e);
            this.maybeFinish();
        }

        private void onSearchFailure(Exception e) {
            this.searchException.set(e);
            this.maybeFinish();
        }

        private void onGetResponse(GetResponse getResponse) {
            try {
                StoredFeatureSet featureSet;
                if (getResponse.isExists()) {
                    this.version.set(getResponse.getVersion());
                    featureSet = IndexFeatureStore.parse(StoredFeatureSet.class, "featureset", getResponse.getSourceAsBytesRef());
                } else {
                    this.version.set(-1L);
                    featureSet = new StoredFeatureSet(this.featureSetName, Collections.emptyList());
                }
                this.setRef.set(featureSet);
            }
            catch (Exception e) {
                this.getException.set(e);
            }
            finally {
                this.maybeFinish();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onSearchResponse(SearchResponse sr) {
            try {
                if (sr.getHits().getTotalHits().value > 10000L) {
                    throw new IllegalArgumentException("The feature query [" + this.featureNamesQuery + "] returns too many features");
                }
                if (sr.getHits().getTotalHits().value == 0L) {
                    throw new IllegalArgumentException("The feature query [" + this.featureNamesQuery + "] returned no features");
                }
                ArrayList<StoredFeature> features = new ArrayList<StoredFeature>(sr.getHits().getHits().length);
                for (SearchHit hit : sr.getHits().getHits()) {
                    features.add(IndexFeatureStore.parse(StoredFeature.class, "feature", hit.getSourceRef()));
                }
                this.featuresRef.set(features);
            }
            catch (Exception e) {
                this.searchException.set(e);
            }
            finally {
                this.maybeFinish();
            }
        }

        private void maybeFinish() {
            if (!this.countdown.countDown()) {
                return;
            }
            try {
                this.checkErrors();
                this.finishRequest();
            }
            catch (Exception e) {
                this.listener.onFailure(e);
            }
        }

        private void finishRequest() throws Exception {
            assert (this.setRef.get() != null && this.featuresRef.get() != null);
            StoredFeatureSet set = this.setRef.get();
            set = this.merge ? set.merge(this.featuresRef.get()) : set.append(this.featuresRef.get());
            this.updateSet(set);
        }

        private void checkErrors() throws Exception {
            Exception exc;
            if (this.searchException.get() == null && this.getException.get() == null) {
                return;
            }
            Exception sExc = this.searchException.get();
            Exception gExc = this.getException.get();
            if (sExc != null && gExc != null) {
                sExc.addSuppressed(gExc);
                exc = sExc;
            } else if (sExc != null) {
                exc = sExc;
            } else {
                assert (gExc != null);
                exc = gExc;
            }
            throw exc;
        }

        private void updateSet(StoredFeatureSet set) {
            long version = this.version.get();
            FeatureStoreAction.FeatureStoreRequest frequest = version > 0L ? new FeatureStoreAction.FeatureStoreRequest(this.store, (StorableElement)set, version) : new FeatureStoreAction.FeatureStoreRequest(this.store, (StorableElement)set, FeatureStoreAction.FeatureStoreRequest.Action.CREATE);
            frequest.setRouting(this.routing);
            frequest.setParentTask(this.clusterService.localNode().getId(), this.task.getId());
            frequest.setValidation(this.validation);
            this.featureStoreAction.execute(frequest, ActionListener.wrap(r -> this.listener.onResponse((Object)new AddFeaturesToSetAction.AddFeaturesToSetResponse(r.getResponse())), arg_0 -> this.listener.onFailure(arg_0)));
        }
    }

    private static class AsyncFetchSet
    implements ActionListener<GetResponse> {
        private ActionListener<AddFeaturesToSetAction.AddFeaturesToSetResponse> listener;

        private AsyncFetchSet() {
        }

        public void onResponse(GetResponse getFields) {
        }

        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }
}

