/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.explore;

import com.o19s.es.explore.PostingsExplorerQuery;
import com.o19s.es.explore.StatisticsHelper;
import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class ExplorerScorer
extends Scorer {
    private final Scorer subScorer;
    private final String type;

    protected ExplorerScorer(Weight weight, String type, Scorer subScorer) {
        super(weight);
        this.type = type;
        this.subScorer = subScorer;
    }

    public float score() throws IOException {
        float retval;
        StatisticsHelper tf_stats = new StatisticsHelper();
        if (this.subScorer.getChildren().size() > 0) {
            for (Scorable.ChildScorable child : this.subScorer.getChildren()) {
                assert (child.child instanceof PostingsExplorerQuery.PostingsExplorerScorer);
                if (child.child.docID() != this.docID()) continue;
                ((PostingsExplorerQuery.PostingsExplorerScorer)child.child).setType(this.type);
                tf_stats.add(child.child.score());
            }
        } else {
            assert (this.subScorer instanceof PostingsExplorerQuery.PostingsExplorerScorer);
            assert (this.subScorer.docID() == this.docID());
            ((PostingsExplorerQuery.PostingsExplorerScorer)this.subScorer).setType(this.type);
            tf_stats.add(this.subScorer.score());
        }
        switch (this.type) {
            case "sum_raw_tf": {
                retval = tf_stats.getSum();
                break;
            }
            case "mean_raw_tf": {
                retval = tf_stats.getMean();
                break;
            }
            case "max_raw_tf": 
            case "max_raw_tp": {
                retval = tf_stats.getMax();
                break;
            }
            case "min_raw_tf": 
            case "min_raw_tp": {
                retval = tf_stats.getMin();
                break;
            }
            case "stddev_raw_tf": {
                retval = tf_stats.getStdDev();
                break;
            }
            case "avg_raw_tp": {
                retval = tf_stats.getMean();
                break;
            }
            default: {
                throw new RuntimeException("Invalid stat type specified.");
            }
        }
        return retval;
    }

    public int docID() {
        return this.subScorer.docID();
    }

    public DocIdSetIterator iterator() {
        return this.subScorer.iterator();
    }

    public float getMaxScore(int upTo) throws IOException {
        return Float.POSITIVE_INFINITY;
    }
}

