/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.util;

import java.text.DecimalFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0018H\u0086\u0002J\u0011\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0018H\u0086\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0011\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\b\u0010 \u001a\u00020\u0018H\u0016R\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006!"}, d2={"Lorg/jitsi/nlj/util/DataSize;", "", "bits", "", "<init>", "(J)V", "value", "getBits", "()J", "bytes", "", "getBytes", "()D", "kiloBytes", "getKiloBytes", "megaBytes", "getMegaBytes", "minus", "other", "minusAssign", "", "plus", "plusAssign", "times", "", "timesAssign", "toString", "", "compareTo", "equals", "", "", "hashCode", "jitsi-media-transform"})
public final class DataSize
implements Comparable<DataSize> {
    private long bits;
    private final double bytes;
    private final double kiloBytes;
    private final double megaBytes;

    public DataSize(long bits) {
        this.bits = bits;
        this.bytes = (double)bits / 8.0;
        this.kiloBytes = this.bytes / 1000.0;
        this.megaBytes = this.kiloBytes / 1000.0;
    }

    public final long getBits() {
        return this.bits;
    }

    public final double getBytes() {
        return this.bytes;
    }

    public final double getKiloBytes() {
        return this.kiloBytes;
    }

    public final double getMegaBytes() {
        return this.megaBytes;
    }

    @NotNull
    public final DataSize minus(@NotNull DataSize other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new DataSize(this.bits - other.bits);
    }

    public final void minusAssign(@NotNull DataSize other) {
        Intrinsics.checkNotNullParameter(other, "other");
        this.bits -= other.bits;
    }

    @NotNull
    public final DataSize plus(@NotNull DataSize other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new DataSize(this.bits + other.bits);
    }

    public final void plusAssign(@NotNull DataSize other) {
        Intrinsics.checkNotNullParameter(other, "other");
        this.bits += other.bits;
    }

    @NotNull
    public final DataSize times(int other) {
        return new DataSize(this.bits * (long)other);
    }

    public final void timesAssign(int other) {
        this.bits *= (long)other;
    }

    @NotNull
    public String toString() {
        DecimalFormat format = new DecimalFormat("0.##");
        return this.megaBytes >= 1.0 ? format.format(this.megaBytes) + " MB" : (this.kiloBytes >= 1.0 ? format.format(this.kiloBytes) + " KB" : (this.bytes >= 1.0 ? format.format(this.bytes) + " B" : format.format(this.bits) + " bits"));
    }

    @Override
    public int compareTo(@NotNull DataSize other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.bits < other.bits ? -1 : (this.bits > other.bits ? 1 : 0);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof DataSize)) {
            return false;
        }
        return this.compareTo((DataSize)other) == 0;
    }

    public int hashCode() {
        return Long.hashCode(this.bits);
    }
}

