/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.codec.vpx;

import kotlin.Metadata;
import org.jitsi.nlj.codec.vpx.VpxUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jitsi/nlj/codec/vpx/PictureIdIndexTracker;", "", "<init>", "()V", "roc", "", "highestSeqNumReceived", "getIndex", "seqNum", "updateRoc", "", "update", "seq", "interpret", "resetAt", "", "jitsi-media-transform"})
public final class PictureIdIndexTracker {
    private int roc;
    private int highestSeqNumReceived = -1;

    private final int getIndex(int seqNum, boolean updateRoc) {
        int v;
        int n;
        if (this.highestSeqNumReceived == -1) {
            if (updateRoc) {
                this.highestSeqNumReceived = seqNum;
            }
            return seqNum;
        }
        int delta = VpxUtils.Companion.getExtendedPictureIdDelta(seqNum, this.highestSeqNumReceived);
        if (delta < 0 && this.highestSeqNumReceived < seqNum) {
            n = this.roc - 1;
        } else if (delta > 0 && seqNum < this.highestSeqNumReceived) {
            int n2;
            int it = n2 = this.roc + 1;
            boolean bl = false;
            if (updateRoc) {
                this.roc = it;
            }
            n = n2;
        } else {
            n = v = this.roc;
        }
        if (updateRoc && delta > 0) {
            this.highestSeqNumReceived = seqNum;
        }
        return 32768 * v + seqNum;
    }

    public final int update(int seq) {
        return this.getIndex(seq, true);
    }

    public final int interpret(int seq) {
        return this.getIndex(seq, false);
    }

    public final void resetAt(int seq) {
        int delta = VpxUtils.Companion.getExtendedPictureIdDelta(seq, this.highestSeqNumReceived);
        if (delta < 0) {
            int n = this.roc;
            this.roc = n + 1;
            this.highestSeqNumReceived = seq;
        }
        this.getIndex(seq, true);
    }
}

