/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.UnitType;

public class UnitTypeChange
extends FreeColSpecObjectType {
    public static final String TAG = "unit-type-change";
    public UnitType from;
    public UnitType to;
    public int probability;
    public int turns;
    private static AtomicInteger fakeIdIndex = new AtomicInteger(0);
    private static final String FROM_TAG = "from";
    private static final String PROBABILITY_TAG = "probability";
    private static final String TO_TAG = "to";
    private static final String TURNS_TAG = "turns";

    public UnitTypeChange(String id, Specification specification) {
        super(id, specification);
    }

    public UnitTypeChange(FreeColXMLReader xr, Specification spec) throws XMLStreamException {
        this(xr.readId(), spec);
        this.readFromXML(xr);
    }

    public boolean isAvailableTo(Player player) {
        return this.to.isAvailableTo(player);
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        UnitTypeChange o = this.copyInCast(other, UnitTypeChange.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.from = o.from;
        this.to = o.to;
        this.probability = o.probability;
        this.turns = o.turns;
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(FROM_TAG, this.from);
        xw.writeAttribute(TO_TAG, this.to);
        xw.writeAttribute(PROBABILITY_TAG, this.probability);
        if (this.turns > 0) {
            xw.writeAttribute(TURNS_TAG, this.turns);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        super.readAttributes(xr);
        this.from = xr.getType(spec, FROM_TAG, UnitType.class, null);
        this.to = xr.getType(spec, TO_TAG, UnitType.class, null);
        this.probability = xr.getAttribute(PROBABILITY_TAG, 0);
        this.turns = xr.getAttribute(TURNS_TAG, -1);
        String id = this.getId();
        if (id == null || "".equals(id)) {
            this.setId("model.unitChange.faked." + fakeIdIndex.incrementAndGet());
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append(this.from.getSuffix()).append("->").append(this.to.getSuffix()).append('/').append(this.probability);
        if (this.turns > 0) {
            sb.append('/').append(this.turns);
        }
        return sb.toString();
    }
}

