/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.plaf;

import java.awt.Font;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalButtonUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.plaf.FreeColButtonUI;
import net.sf.freecol.client.gui.plaf.FreeColCheckBoxUI;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxUI;
import net.sf.freecol.client.gui.plaf.FreeColFileChooserUI;
import net.sf.freecol.client.gui.plaf.FreeColFormattedTextFieldUI;
import net.sf.freecol.client.gui.plaf.FreeColLabelUI;
import net.sf.freecol.client.gui.plaf.FreeColListUI;
import net.sf.freecol.client.gui.plaf.FreeColMenuBarUI;
import net.sf.freecol.client.gui.plaf.FreeColMenuItemUI;
import net.sf.freecol.client.gui.plaf.FreeColOptionPaneUI;
import net.sf.freecol.client.gui.plaf.FreeColPanelUI;
import net.sf.freecol.client.gui.plaf.FreeColPopupMenuUI;
import net.sf.freecol.client.gui.plaf.FreeColRadioButtonUI;
import net.sf.freecol.client.gui.plaf.FreeColScrollPaneUI;
import net.sf.freecol.client.gui.plaf.FreeColSpinnerUI;
import net.sf.freecol.client.gui.plaf.FreeColTableHeaderUI;
import net.sf.freecol.client.gui.plaf.FreeColTableUI;
import net.sf.freecol.client.gui.plaf.FreeColTextAreaUI;
import net.sf.freecol.client.gui.plaf.FreeColTextFieldUI;
import net.sf.freecol.client.gui.plaf.FreeColToolTipUI;
import net.sf.freecol.client.gui.plaf.FreeColTransparentPanelUI;
import net.sf.freecol.common.FreeColException;

public class FreeColLookAndFeel
extends MetalLookAndFeel {
    private static final Logger logger = Logger.getLogger(FreeColLookAndFeel.class.getName());
    private static final String brightPanelUI = "net.sf.freecol.client.gui.plaf.FreeColBrightPanelUI";
    private static final String transparentPanelUI = "net.sf.freecol.client.gui.plaf.FreeColTransparentPanelUI";
    private static final Class[] uiClasses = new Class[]{FreeColButtonUI.class, FreeColCheckBoxUI.class, FreeColComboBoxUI.class, FreeColFileChooserUI.class, FreeColLabelUI.class, FreeColListUI.class, FreeColMenuBarUI.class, FreeColMenuItemUI.class, FreeColOptionPaneUI.class, FreeColPanelUI.class, FreeColPopupMenuUI.class, FreeColRadioButtonUI.class, FreeColScrollPaneUI.class, FreeColTableHeaderUI.class, FreeColTableUI.class, FreeColTextAreaUI.class, FreeColTextFieldUI.class, FreeColFormattedTextFieldUI.class, FreeColToolTipUI.class, FreeColTransparentPanelUI.class, FreeColSpinnerUI.class};

    public FreeColLookAndFeel() throws FreeColException {
        FreeColLookAndFeel.setCurrentTheme(new FreeColMetalTheme());
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults u = super.getDefaults();
        int offset = "FreeCol".length();
        for (Class uiClass : uiClasses) {
            String name = uiClass.getName();
            int index = name.lastIndexOf("FreeCol");
            if (index < 0) continue;
            String shortName = name.substring(index += offset);
            u.put(shortName, name);
            u.put(name, uiClass);
        }
        try {
            u.put(brightPanelUI, Class.forName(brightPanelUI));
            u.put("InPortPanelUI", brightPanelUI);
            u.put("CargoPanelUI", brightPanelUI);
            u.put("BuildingsPanelUI", brightPanelUI);
            u.put("OutsideColonyPanelUI", brightPanelUI);
            u.put("WarehousePanelUI", brightPanelUI);
            u.put("ConstructionPanelUI", brightPanelUI);
            u.put("PopulationPanelUI", brightPanelUI);
            u.put("WarehouseGoodsPanelUI", brightPanelUI);
            u.put("ReportPanelUI", brightPanelUI);
            u.put("ColopediaPanelUI", brightPanelUI);
            u.put("TilePanelUI", brightPanelUI);
            u.put("OptionGroupUI", brightPanelUI);
        }
        catch (ClassNotFoundException cnfe) {
            logger.log(Level.WARNING, "Could not load net.sf.freecol.client.gui.plaf.FreeColBrightPanelUI", cnfe);
        }
        try {
            u.put(transparentPanelUI, Class.forName(transparentPanelUI));
            u.put("MarketPanelUI", transparentPanelUI);
            u.put("EuropeCargoPanelUI", transparentPanelUI);
            u.put("ToAmericaPanelUI", transparentPanelUI);
            u.put("ToEuropePanelUI", transparentPanelUI);
            u.put("EuropeInPortPanelUI", transparentPanelUI);
            u.put("DocksPanelUI", transparentPanelUI);
        }
        catch (ClassNotFoundException cnfe) {
            logger.log(Level.WARNING, "Could not load net.sf.freecol.client.gui.plaf.FreeColTransparentPanelUI", cnfe);
        }
        u.put("javax.swing.plaf.metal.MetalButtonUI", MetalButtonUI.class);
        u.put("ColorButtonUI", "javax.swing.plaf.metal.MetalButtonUI");
        u.put("cursor.go", ImageLibrary.getCursor());
        u.put("CheckBox.icon", t -> FreeColCheckBoxUI.createCheckBoxIcon());
        return u;
    }

    public static void install(FreeColLookAndFeel fclaf) throws FreeColException {
        try {
            UIManager.setLookAndFeel(fclaf);
            UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        }
        catch (UnsupportedLookAndFeelException e) {
            throw new FreeColException("Look and feel install failure: " + fclaf, e);
        }
    }

    public static void installFont(Font defaultFont) {
        UIDefaults u = UIManager.getLookAndFeelDefaults();
        HashSet keySet = new HashSet(u.keySet());
        for (Object key : keySet) {
            if (u.get(key) instanceof FontUIResource) {
                u.put(key, defaultFont);
                continue;
            }
            if (!(u.get(key) instanceof Font)) continue;
            u.put(key, defaultFont);
        }
    }

    @Override
    public String getDescription() {
        return "The default Look and Feel for FreeCol";
    }

    @Override
    public String getName() {
        return "FreeCol Look and Feel";
    }

    private static class FreeColMetalTheme
    extends DefaultMetalTheme {
        private FreeColMetalTheme() {
        }

        private static ColorUIResource getColor(String resourceName) {
            return new ColorUIResource(ImageLibrary.getColor(resourceName));
        }

        @Override
        protected ColorUIResource getPrimary1() {
            return FreeColMetalTheme.getColor("color.primary1.LookAndFeel");
        }

        @Override
        protected ColorUIResource getPrimary2() {
            return FreeColMetalTheme.getColor("color.backgroundSelect.LookAndFeel");
        }

        @Override
        protected ColorUIResource getPrimary3() {
            return FreeColMetalTheme.getColor("color.primary3.LookAndFeel");
        }

        @Override
        protected ColorUIResource getSecondary1() {
            return FreeColMetalTheme.getColor("color.secondary1.LookAndFeel");
        }

        @Override
        protected ColorUIResource getSecondary2() {
            return FreeColMetalTheme.getColor("color.disabled.LookAndFeel");
        }

        @Override
        protected ColorUIResource getSecondary3() {
            return FreeColMetalTheme.getColor("color.background.LookAndFeel");
        }

        @Override
        public ColorUIResource getMenuDisabledForeground() {
            return FreeColMetalTheme.getColor("color.disabledMenu.LookAndFeel");
        }
    }
}

