"use strict";

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

module.exports = {
  rootDir: '../',
  setupFiles: ['<rootDir>/test/polyfills.ts', '<rootDir>/test/setupTests.ts'],
  setupFilesAfterEnv: ['<rootDir>/test/setup.jest.ts'],
  roots: ['<rootDir>'],
  coverageDirectory: './coverage',
  moduleNameMapper: {
    '\\.(css|less|scss)$': '<rootDir>/test/mocks/styleMock.ts',
    '^ui/(.*)': '<rootDir>/../../src/legacy/ui/public/$1/',
    '.*content_management/public.*': '<rootDir>/test/mocks/contentManagementMocks.ts'
  },
  coverageReporters: ['lcov', 'text', 'cobertura'],
  testMatch: ['**/*.test.js', '**/*.test.jsx', '**/*.test.ts', '**/*.test.tsx'],
  collectCoverageFrom: ['**/*.ts', '**/*.tsx', '**/*.js', '**/*.jsx', '!**/models/**', '!**/node_modules/**', '!**/index.ts', '!<rootDir>/index.js', '!<rootDir>/public/app.js', '!<rootDir>/public/temporary/**', '!<rootDir>/babel.config.js', '!<rootDir>/test/**', '!<rootDir>/server/**', '!<rootDir>/coverage/**', '!<rootDir>/scripts/**', '!<rootDir>/build/**', '!<rootDir>/cypress/**', '!**/vendor/**'],
  clearMocks: true,
  testPathIgnorePatterns: ['<rootDir>/build/', '<rootDir>/node_modules/'],
  modulePathIgnorePatterns: ['securityAnalyticsDashboards'],
  testEnvironment: 'jsdom',
  snapshotSerializers: ['enzyme-to-json/serializer']
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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