"use strict";

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

module.exports = {
  rootDir: '../',
  setupFiles: ['<rootDir>/test/polyfills.ts', '<rootDir>/test/setupTests.ts'],
  setupFilesAfterEnv: ['<rootDir>/test/setup.jest.ts'],
  roots: ['<rootDir>'],
  coverageDirectory: './coverage',
  moduleNameMapper: {
    '\\.(css|less|scss)$': '<rootDir>/test/mocks/styleMock.ts'
  },
  testEnvironment: 'jest-environment-jsdom',
  coverageReporters: ['lcov', 'text', 'cobertura'],
  testMatch: ['**/*.test.js', '**/*.test.jsx', '**/*.test.ts', '**/*.test.tsx'],
  collectCoverageFrom: ['**/*.ts', '**/*.tsx', '**/*.js', '**/*.jsx', '!**/models/**', '!**/node_modules/**', '!**/index.js', '!<rootDir>/public/app.js', '!<rootDir>/index.js', '!<rootDir>/babel.config.js', '!<rootDir>/test/**', '!<rootDir>/server/**', '!<rootDir>/coverage/**', '!<rootDir>/scripts/**', '!<rootDir>/build/**', '!**/vendor/**'],
  clearMocks: true,
  modulePathIgnorePatterns: ['<rootDir>/offline-module-cache/'],
  testPathIgnorePatterns: ['<rootDir>/build/', '<rootDir>/node_modules/'],
  transformIgnorePatterns: ['<rootDir>/node_modules'],
  globalSetup: '<rootDir>/global-setup.js',
  /**
   * This configuration specifies different file extensions 
   * and the corresponding transformers to be used
   */
  transform: {
    '\\.[jt]sx?$': 'babel-jest',
    '^.+\\.svg$': '<rootDir>/test/mocks/transformMock.ts',
    '^.+\\.html$': '<rootDir>/test/mocks/transformMock.ts'
  },
  setupFiles: ["jest-canvas-mock"]
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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