/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;

public abstract class WrapperMessage
extends AttributeMessage {
    public static final String REPLY_ID_TAG = "networkReplyId";
    private Message message = null;

    protected WrapperMessage(String tag, int replyId, Message message) {
        super(tag, REPLY_ID_TAG, String.valueOf(replyId));
        this.message = message;
    }

    protected WrapperMessage(String tag, Game game, FreeColXMLReader xr) throws XMLStreamException, FreeColException {
        super(tag, REPLY_ID_TAG, xr.getAttribute(REPLY_ID_TAG, null));
        this.message = null;
        while (xr.moreTags()) {
            String mt = xr.getLocalName();
            if (this.message == null) {
                this.message = Message.read(game, xr);
                xr.expectTag(mt);
                continue;
            }
            xr.expectTag(tag);
        }
        xr.expectTag(tag);
    }

    @Override
    public boolean isEmpty() {
        return this.message == null && super.isEmpty();
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) throws FreeColException {
        if (this.message != null) {
            this.message.clientHandler(freeColClient);
        }
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        return this.message == null ? null : this.message.serverHandler(freeColServer, serverPlayer);
    }

    @Override
    public void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        if (this.message != null) {
            this.message.toXML(xw);
        }
    }

    public Message getMessage() {
        return this.message;
    }

    public String getSubType() {
        return this.message == null ? null : this.message.getType();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append('[');
        WrapperMessage.pretty(sb, this.getType(), this.getStringAttributeMap(), null);
        if (this.message != null) {
            sb.append(' ').append(this.message);
        }
        sb.append(']');
        return sb.toString();
    }
}

