<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="xml" encoding="UTF-8" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" />

<!-- refresh time in seconds. Use "0" to disable -->
<xsl:variable name="refresh-time">300</xsl:variable>

<xsl:template match="pflogx">
	<html>
	<head>
		<xsl:if test="$refresh-time != 0">
			<meta http-equiv="Refresh" content="{$refresh-time}" />
		</xsl:if>
		<title>pflogx - Packet filter logs</title>
	</head>
	<body>
		<xsl:apply-templates/>
	</body>
	</html>
</xsl:template>

<xsl:template match="logs">
	<table border="1">
	<tr>
		<th>Date</th>
		<th>Interface</th>
		<th>Action</th>
		<th>Rule</th>
		<th>Direction</th>
		<th>Protocol</th>
		<th>Src. address</th>
		<th>Src. port</th>
		<th>Dest. address</th>
		<th>Dest. port</th>
	</tr>
	<xsl:apply-templates/>
	</table>
</xsl:template>

<xsl:template match="log">
	<tr>
		<xsl:for-each select="@*">
			<td><xsl:value-of select="." /></td>
		</xsl:for-each>
	</tr>
</xsl:template>

</xsl:stylesheet>
