"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadAssetsFromFile = exports.assetMapper = void 0;
var _fs = _interopRequireDefault(require("fs"));
var _path = _interopRequireDefault(require("path"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const assetMapper = tutorialId => {
  switch (tutorialId) {
    case 'otel':
      return 'otel-index-patterns-1.0.0.ndjson';
    case 'nginx':
      return 'nginx-1.0.0.ndjson';
    case 'java':
      return 'java-tutorial-1.0.0.ndjson';
    case 'python':
      return 'python-tutorial-1.0.0.ndjson';
    case 'golang':
      return 'golang-tutorial-1.0.0.ndjson';
    case 'csv':
      return 'fluent-bit-csv-upload-1.0.0.ndjson';
    case 'data-prepper':
      return 'dummy.ndjson';
    default:
      return '';
  }
};
exports.assetMapper = assetMapper;
const loadAssetsFromFile = async tutorialId => {
  try {
    const fileName = assetMapper(tutorialId);
    const filePath = _path.default.join(__dirname, `assets/${fileName}`);
    const fileData = await _fs.default.promises.readFile(filePath, 'utf8');
    return fileData;
  } catch (error) {
    throw new Error('Issue is loading asset');
  }
};
exports.loadAssetsFromFile = loadAssetsFromFile;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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