/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.xml.handlers;

import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.xml.HTMLUtils;
import com.adobe.epubcheck.xml.handlers.LocationHandler;
import com.adobe.epubcheck.xml.handlers.WrappingDefaultHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public final class PreprocessingDefaultHandler
extends WrappingDefaultHandler {
    private final ValidationContext context;
    private Locator locator;

    private static String findReservedStringInHTMLCustomNamespace(String namespace) {
        if (namespace != null) {
            try {
                URI uri = new URI(namespace);
                if (uri.getHost().contains("w3.org")) {
                    return "w3.org";
                }
                if (uri.getHost().contains("idpf.org")) {
                    return "idpf.org";
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public PreprocessingDefaultHandler(DefaultHandler handler, ValidationContext context) {
        super(handler);
        this.context = context;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        super.setDocumentLocator(locator);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(this.preprocessNamespace(uri, localName), localName, qName, this.preprocessAttributes(uri, attributes));
    }

    private String preprocessNamespace(String uri, String localName) {
        if (this.context.version == EPUBVersion.VERSION_3 && "application/xhtml+xml".equals(this.context.mimeType) && HTMLUtils.isCustomElement(uri, localName)) {
            return "http://n.validator.nu/custom-elements/";
        }
        return uri;
    }

    private Attributes preprocessAttributes(String elemNamespace, Attributes atts) {
        AttributesImpl attributes = new AttributesImpl(atts);
        try {
            for (int i = attributes.getLength() - 1; i >= 0; --i) {
                String namespace = attributes.getURI(i);
                String name = attributes.getLocalName(i);
                if (this.context.version != EPUBVersion.VERSION_3) continue;
                if (HTMLUtils.isDataAttribute(namespace, name)) {
                    if (!HTMLUtils.isValidDataAttribute(name)) {
                        this.context.report.message(MessageId.HTM_061, LocationHandler.location(this.context, this.locator), name);
                    }
                    attributes.removeAttribute(i);
                    continue;
                }
                if ("application/xhtml+xml".equals(this.context.mimeType) && HTMLUtils.isCustomNamespace(namespace)) {
                    String reserved = PreprocessingDefaultHandler.findReservedStringInHTMLCustomNamespace(namespace);
                    if (reserved != null) {
                        this.context.report.message(MessageId.HTM_054, LocationHandler.location(this.context, this.locator), namespace, reserved);
                    }
                    attributes.removeAttribute(i);
                    continue;
                }
                if (!"application/xhtml+xml".equals(this.context.mimeType) || !"http://www.w3.org/1999/xhtml".equals(elemNamespace) || !HTMLUtils.isCaseInsensitiveAttribute(namespace, name)) continue;
                attributes.setValue(i, attributes.getValue(i).toLowerCase(Locale.ENGLISH));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected error when pre-processing attributes", e);
        }
        return attributes;
    }
}

