/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.Column;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.DoubleType;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.Type;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010(\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0006j\b\u0012\u0004\u0012\u00020\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0016j\b\u0012\u0004\u0012\u00020\u0017`\u00182\u0006\u0010\u0019\u001a\u00020\nH\u0016J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001fH\u0096\u0002R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/columns/DoubleColumn;", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/columns/Column;", "", "name", "", "data", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "(Ljava/lang/String;Ljava/util/ArrayList;)V", "isNumerical", "", "()Z", "lazyRange", "Lkotlin/ranges/ClosedRange;", "range", "getRange", "()Lkotlin/ranges/ClosedRange;", "type", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/columns/Type;", "getType", "()Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/columns/Type;", "getComparator", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "descendant", "getDouble", "index", "isNotNull", "isNull", "iterator", "", "intellij.notebooks.visualization"})
public final class DoubleColumn
extends Column<Double> {
    private final boolean isNumerical;
    @Nullable
    private ClosedRange<Double> lazyRange;

    public DoubleColumn(@NotNull String name, @NotNull ArrayList<Double> data2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(data2, (String)"data");
        super(name, data2);
        this.isNumerical = true;
    }

    @Override
    @NotNull
    public Type<Double> getType() {
        return DoubleType.INSTANCE;
    }

    @Override
    public boolean isNumerical() {
        return this.isNumerical;
    }

    @Override
    public boolean isNotNull(int index) {
        Object t = this.getData().get(index);
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return !Double.isNaN(((Number)t).doubleValue());
    }

    @Override
    public boolean isNull(int index) {
        Object t = this.getData().get(index);
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return Double.isNaN(((Number)t).doubleValue());
    }

    @Override
    public double getDouble(int index) {
        Object t = this.getData().get(index);
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return ((Number)t).doubleValue();
    }

    @Override
    @NotNull
    public Comparator<Integer> getComparator(boolean descendant) {
        return descendant ? (arg_0, arg_1) -> DoubleColumn.getComparator$lambda$0(this, arg_0, arg_1) : (arg_0, arg_1) -> DoubleColumn.getComparator$lambda$1(this, arg_0, arg_1);
    }

    @Override
    @NotNull
    public ClosedRange<Double> getRange() {
        if (this.lazyRange != null) {
            ClosedRange<Double> closedRange = this.lazyRange;
            Intrinsics.checkNotNull(closedRange);
            return closedRange;
        }
        double min2 = Double.MAX_VALUE;
        double max2 = Double.MIN_VALUE;
        int n = this.getData().size();
        for (int i = 0; i < n; ++i) {
            Object t = this.getData().get(i);
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            if (Double.isNaN(((Number)t).doubleValue())) continue;
            Object t2 = this.getData().get(i);
            Intrinsics.checkNotNullExpressionValue(t2, (String)"get(...)");
            if (min2 > ((Number)t2).doubleValue()) {
                Object t3 = this.getData().get(i);
                Intrinsics.checkNotNullExpressionValue(t3, (String)"get(...)");
                min2 = ((Number)t3).doubleValue();
            }
            Object t4 = this.getData().get(i);
            Intrinsics.checkNotNullExpressionValue(t4, (String)"get(...)");
            if (!(max2 < ((Number)t4).doubleValue())) continue;
            Object t5 = this.getData().get(i);
            Intrinsics.checkNotNullExpressionValue(t5, (String)"get(...)");
            max2 = ((Number)t5).doubleValue();
        }
        this.lazyRange = (ClosedRange)RangesKt.rangeTo((double)min2, (double)max2);
        ClosedRange<Double> closedRange = this.lazyRange;
        Intrinsics.checkNotNull(closedRange);
        return closedRange;
    }

    @Override
    @NotNull
    public Iterator<Double> iterator() {
        Iterator<Double> iterator2 = this.getData().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        return iterator2;
    }

    private static final int getComparator$lambda$0(DoubleColumn this$0, Integer i1, Integer i2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)i2);
        double d = ((Number)this$0.get(i2)).doubleValue();
        Intrinsics.checkNotNull((Object)i1);
        return Double.compare(d, ((Number)this$0.get(i1)).doubleValue());
    }

    private static final int getComparator$lambda$1(DoubleColumn this$0, Integer i1, Integer i2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)i1);
        double d = ((Number)this$0.get(i1)).doubleValue();
        Intrinsics.checkNotNull((Object)i2);
        return Double.compare(d, ((Number)this$0.get(i2)).doubleValue());
    }
}

