/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.extensions.probit;

import io.kinference.ndarray.arrays.DoubleNDArray;
import io.kinference.ndarray.arrays.FloatNDArray;
import io.kinference.ndarray.arrays.MutableDoubleNDArray;
import io.kinference.ndarray.arrays.MutableFloatNDArray;
import io.kinference.ndarray.arrays.MutableNumberNDArrayCore;
import io.kinference.ndarray.arrays.NumberNDArrayCore;
import io.kinference.ndarray.extensions.probit.ProbitDoubleKt;
import io.kinference.ndarray.extensions.probit.ProbitFloatKt;
import io.kinference.primitives.types.DataType;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0086@\u00a2\u0006\u0002\u0010\u0004\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0001H\u0086@\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"probit", "Lio/kinference/ndarray/arrays/MutableNumberNDArrayCore;", "input", "Lio/kinference/ndarray/arrays/NumberNDArrayCore;", "(Lio/kinference/ndarray/arrays/NumberNDArrayCore;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dest", "(Lio/kinference/ndarray/arrays/NumberNDArrayCore;Lio/kinference/ndarray/arrays/MutableNumberNDArrayCore;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ndarray-core"})
public final class ProbitKt {
    @Nullable
    public static final Object probit(@NotNull NumberNDArrayCore input, @NotNull Continuation<? super MutableNumberNDArrayCore> $completion) {
        MutableNumberNDArrayCore mutableNumberNDArrayCore;
        if (!(input.getType() == DataType.FLOAT || input.getType() == DataType.DOUBLE)) {
            boolean bl = false;
            String string = "Probit operation supported only for FLOAT and DOUBLE tensors, actual type is " + input.getType();
            throw new IllegalArgumentException(string.toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[input.getType().ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull((Object)input, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.FloatNDArray");
                Object object = ProbitFloatKt.probitFloat((FloatNDArray)input, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                mutableNumberNDArrayCore = (MutableNumberNDArrayCore)object;
                break;
            }
            case 2: {
                Intrinsics.checkNotNull((Object)input, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.DoubleNDArray");
                Object object = ProbitDoubleKt.probitDouble((DoubleNDArray)input, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                mutableNumberNDArrayCore = (MutableNumberNDArrayCore)object;
                break;
            }
            default: {
                throw new IllegalStateException(("Probit operation supported only for FLOAT and DOUBLE tensors, actual type is " + input.getType()).toString());
            }
        }
        return mutableNumberNDArrayCore;
    }

    @Nullable
    public static final Object probit(@NotNull NumberNDArrayCore input, @NotNull MutableNumberNDArrayCore dest, @NotNull Continuation<? super MutableNumberNDArrayCore> $completion) {
        MutableNumberNDArrayCore mutableNumberNDArrayCore;
        if (!(input.getType() == dest.getType())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(input.getType() == DataType.FLOAT || input.getType() == DataType.DOUBLE)) {
            boolean bl = false;
            String string = "Probit operation supported only for FLOAT and DOUBLE tensors, actual type is " + input.getType();
            throw new IllegalArgumentException(string.toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[input.getType().ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull((Object)input, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.FloatNDArray");
                FloatNDArray floatNDArray = (FloatNDArray)input;
                Intrinsics.checkNotNull((Object)dest, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.MutableFloatNDArray");
                Object object = ProbitFloatKt.probitFloat(floatNDArray, (MutableFloatNDArray)dest, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                mutableNumberNDArrayCore = (MutableNumberNDArrayCore)object;
                break;
            }
            case 2: {
                Intrinsics.checkNotNull((Object)input, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.DoubleNDArray");
                DoubleNDArray doubleNDArray = (DoubleNDArray)input;
                Intrinsics.checkNotNull((Object)dest, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.MutableDoubleNDArray");
                Object object = ProbitDoubleKt.probitDouble(doubleNDArray, (MutableDoubleNDArray)dest, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                mutableNumberNDArrayCore = (MutableNumberNDArrayCore)object;
                break;
            }
            default: {
                throw new IllegalStateException(("Probit operation supported only for FLOAT and DOUBLE tensors, actual type is " + input.getType()).toString());
            }
        }
        return mutableNumberNDArrayCore;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DataType.values().length];
            try {
                nArray[DataType.FLOAT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.DOUBLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

