/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer.backend.providers.vswin;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.startup.importSettings.TransferSettingsConfiguration;
import com.intellij.ide.startup.importSettings.TransferableIdeId;
import com.intellij.ide.startup.importSettings.TransferableIdeVersionId;
import com.intellij.ide.startup.importSettings.db.KnownPlugins;
import com.intellij.ide.startup.importSettings.fus.TransferSettingsCollector;
import com.intellij.ide.startup.importSettings.models.BaseIdeVersion;
import com.intellij.ide.startup.importSettings.models.FailedIdeVersion;
import com.intellij.ide.startup.importSettings.models.IdeVersion;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.providers.TransferSettingsProvider;
import com.intellij.ide.startup.importSettings.providers.vswin.parsers.VSIsolationIniParser;
import com.intellij.ide.startup.importSettings.providers.vswin.parsers.VSParser;
import com.intellij.ide.startup.importSettings.providers.vswin.parsers.VSRegistryParserNew;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.VSHive;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.VSHiveDetourFileNotFoundException;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.VSPossibleVersionsEnumerator;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.VSProfileDetectorUtils;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vswin.VSWinTransferSettingsProvider;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vswin.VSWinTransferSettingsProviderKt;
import com.intellij.ide.startup.importSettings.ui.representation.TransferSettingsRightPanelChooser;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.dsl.builder.BuilderKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0019H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\u00020#H\u0096@\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020#H\u0016J\b\u0010&\u001a\u00020\u0015H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0013\u0010\u000b\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006("}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/VSWinTransferSettingsProvider;", "Lcom/intellij/ide/startup/importSettings/providers/TransferSettingsProvider;", "()V", "defaultAdvice", "", "Lorg/jetbrains/annotations/Nls;", "failureReason", "getFailureReason", "()Ljava/lang/String;", "name", "getName", "noSettings", "transferableIdeId", "Lcom/intellij/ide/startup/importSettings/TransferableIdeId;", "getTransferableIdeId", "()Lcom/intellij/ide/startup/importSettings/TransferableIdeId;", "vsEnumerator", "Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/VSPossibleVersionsEnumerator;", "convertTimeFn", "Lkotlin/time/Duration;", "time", "", "convertTimeFn-5sfh64U", "(J)J", "getIdeVersions", "", "Lcom/intellij/ide/startup/importSettings/models/BaseIdeVersion;", "skipIds", "getRightPanel", "Lcom/intellij/ide/startup/importSettings/ui/representation/TransferSettingsRightPanelChooser;", "ideV", "Lcom/intellij/ide/startup/importSettings/models/IdeVersion;", "config", "Lcom/intellij/ide/startup/importSettings/TransferSettingsConfiguration;", "hasDataToImport", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isAvailable", "timeFn", "VSWinTransferSettingsRightPanelChooser", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nVSWinTransferSettingsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VSWinTransferSettingsProvider.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/VSWinTransferSettingsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,220:1\n1603#2,9:221\n1855#2:230\n1856#2:233\n1612#2:234\n1#3:231\n1#3:232\n*S KotlinDebug\n*F\n+ 1 VSWinTransferSettingsProvider.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/VSWinTransferSettingsProvider\n*L\n48#1:221,9\n48#1:230\n48#1:233\n48#1:234\n48#1:232\n*E\n"})
public final class VSWinTransferSettingsProvider
implements TransferSettingsProvider {
    @NotNull
    private final TransferableIdeId transferableIdeId = TransferableIdeId.VisualStudio;
    @NotNull
    private final String name;
    @NotNull
    private final String defaultAdvice;
    @NotNull
    private final String failureReason;
    @NotNull
    private final String noSettings;
    @NotNull
    private final VSPossibleVersionsEnumerator vsEnumerator;

    public VSWinTransferSettingsProvider() {
        this.name = "Visual Studio";
        String string = IdeBundle.message((String)"transfersettings.vs.quit.advise", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.defaultAdvice = string;
        Object[] objectArray = new Object[]{this.defaultAdvice};
        String string2 = IdeBundle.message((String)"transfersettings.vs.failureReason", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.failureReason = string2;
        String string3 = IdeBundle.message((String)"transfersettings.vs.noSettings", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        this.noSettings = string3;
        this.vsEnumerator = new VSPossibleVersionsEnumerator();
    }

    @Override
    @NotNull
    public TransferableIdeId getTransferableIdeId() {
        return this.transferableIdeId;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final String getFailureReason() {
        return this.failureReason;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<BaseIdeVersion> getIdeVersions(@NotNull List<String> skipIds) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(skipIds, (String)"skipIds");
        Ref.ObjectRef speedResult = new Ref.ObjectRef();
        speedResult.element = "";
        List badVersions = new ArrayList();
        Iterable $this$mapNotNull$iv = this.vsEnumerator.get();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IdeVersion ideVersion;
            block19: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                VSHive hive = (VSHive)element$iv$iv;
                boolean bl2 = false;
                long start2 = this.timeFn();
                VSWinTransferSettingsProviderKt.access$getLogger$p().info("Started processing " + hive.getHiveString());
                String instanceIdForIdeVersion = "VisualStudio" + hive.getHiveString();
                String customRt = System.getProperty("trl.oneHs");
                if (customRt != null && !Intrinsics.areEqual((Object)hive.getHiveString(), (Object)customRt)) {
                    ideVersion = null;
                } else {
                    speedResult.element = speedResult.element + "START " + instanceIdForIdeVersion + " ---------------------------\n";
                    String string = System.getProperty("trl.transfer.debug");
                    String name = (string != null ? Boolean.parseBoolean(string) : false) ? StringsKt.replace$default((String)hive.getPresentationString(), (String)"Visual Studio", (String)"VS", (boolean)false, (int)4, null) + " " + hive.getHiveString() : hive.getPresentationString();
                    TransferableIdeId transferableIdeId = this.getTransferableIdeId();
                    String string2 = hive.getHiveString();
                    Icon icon = AllIcons.Idea_logo_welcome;
                    Object object = this.defaultAdvice;
                    String string3 = this.failureReason;
                    Intrinsics.checkNotNull((Object)icon);
                    FailedIdeVersion failedIde = new FailedIdeVersion(transferableIdeId, instanceIdForIdeVersion, icon, name, string2, string3, (String)object, true, null, 256, null);
                    long registryTime = this.timeFn();
                    try {
                        object = hive.getRegistry();
                    }
                    catch (VSHiveDetourFileNotFoundException t) {
                        VSWinTransferSettingsProviderKt.access$getLogger$p().info("File not found. Probably vs was uninstalled");
                        ideVersion = null;
                        break block19;
                    }
                    Object registry2 = object;
                    long res2 = this.convertTimeFn-5sfh64U(this.timeFn() - registryTime);
                    speedResult.element = speedResult.element + "registryTime " + Duration.toString-impl((long)res2) + "\n";
                    TransferSettingsCollector.INSTANCE.logPerformanceMeasured-Wn2Vu4Y(TransferSettingsCollector.PerformanceMetricType.Registry, TransferableIdeId.VisualStudio, hive.transferableVersion(), res2);
                    if (registry2 == null) {
                        VSWinTransferSettingsProviderKt.access$getLogger$p().warn("Critical. Failed to init registry");
                        badVersions.add(failedIde);
                        ideVersion = null;
                    } else if (!hive.isInstalled()) {
                        VSWinTransferSettingsProviderKt.access$getLogger$p().info("This instance of Visual Studio was uninstalled");
                        ideVersion = null;
                    } else {
                        String string4;
                        StringBuilder stringBuilder;
                        long subNameTime = this.timeFn();
                        StringBuilder $this$getIdeVersions_u24lambda_u244_u24lambda_u241 = stringBuilder = new StringBuilder();
                        boolean bl3 = false;
                        try {
                            VSIsolationIniParser vSIsolationIniParser;
                            String string5 = hive.getEdition();
                            if (string5 == null) {
                                string5 = "";
                            }
                            $this$getIdeVersions_u24lambda_u244_u24lambda_u241.append(string5);
                            VSIsolationIniParser vSIsolationIniParser2 = vSIsolationIniParser = hive.getIsolation();
                            $this$getIdeVersions_u24lambda_u244_u24lambda_u241.append((vSIsolationIniParser2 != null ? vSIsolationIniParser2.isPreview() : false) ? " Preview" : "");
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        String it = VSProfileDetectorUtils.INSTANCE.rootSuffixStabilizer(hive);
                        boolean bl4 = false;
                        if (it != null) {
                            $this$getIdeVersions_u24lambda_u244_u24lambda_u241.append(" (" + it + ")");
                        }
                        StringBuilder it2 = stringBuilder;
                        boolean bl5 = false;
                        if (((CharSequence)it2).length() == 0) {
                            string4 = null;
                        } else {
                            String string6 = it2.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
                            string4 = ((Object)StringsKt.trimStart((CharSequence)string6)).toString();
                        }
                        String subName = string4;
                        long res1 = this.convertTimeFn-5sfh64U(this.timeFn() - subNameTime);
                        speedResult.element = speedResult.element + "subname " + Duration.toString-impl((long)res1) + "\n";
                        TransferSettingsCollector.INSTANCE.logPerformanceMeasured-Wn2Vu4Y(TransferSettingsCollector.PerformanceMetricType.SubName, TransferableIdeId.VisualStudio, hive.transferableVersion(), res1);
                        long readSettingsTime = this.timeFn();
                        try {
                            if (((VSRegistryParserNew)registry2).getSettingsFile() == null) {
                                String string7 = "Required value was null.";
                                throw new IllegalArgumentException(string7.toString());
                            }
                        }
                        catch (Throwable t) {
                            void $this$getIdeVersions_u24lambda_u244_u24lambda_u243;
                            FailedIdeVersion failedIdeVersion;
                            VSWinTransferSettingsProviderKt.access$getLogger$p().warn("Critical. Failed to read file");
                            VSWinTransferSettingsProviderKt.access$getLogger$p().warn(t);
                            FailedIdeVersion failedIdeVersion2 = failedIdeVersion = failedIde;
                            List list = badVersions;
                            boolean bl6 = false;
                            $this$getIdeVersions_u24lambda_u244_u24lambda_u243.setStepsToFix(this.noSettings);
                            list.add(failedIdeVersion);
                            ideVersion = null;
                            break block19;
                        }
                        long res3 = this.convertTimeFn-5sfh64U(this.timeFn() - readSettingsTime);
                        speedResult.element = speedResult.element + "readSettingsFile " + Duration.toString-impl((long)res3) + "\n";
                        TransferSettingsCollector.INSTANCE.logPerformanceMeasured-Wn2Vu4Y(TransferSettingsCollector.PerformanceMetricType.ReadSettingsFile, TransferableIdeId.VisualStudio, hive.transferableVersion(), res3);
                        TransferableIdeId transferableIdeId2 = this.getTransferableIdeId();
                        TransferableIdeVersionId transferableIdeVersionId = hive.transferableVersion();
                        Icon icon2 = AllIcons.TransferSettings.VS;
                        Date date = hive.getLastUsage();
                        Intrinsics.checkNotNull((Object)icon2);
                        IdeVersion l2 = new IdeVersion(transferableIdeId2, transferableIdeVersionId, instanceIdForIdeVersion, icon2, name, subName, (Function0<? extends Settings>)((Function0)new Function0<Settings>(hive){
                            final /* synthetic */ VSHive $hive;
                            {
                                this.$hive = $hive;
                                super(0);
                            }

                            @NotNull
                            public final Settings invoke() {
                                return new VSParser(this.$hive).getSettings();
                            }
                        }), date, this);
                        long res4 = this.convertTimeFn-5sfh64U(this.timeFn() - start2);
                        speedResult.element = speedResult.element + hive.getHiveString() + " " + Duration.toString-impl((long)res4) + "\n\n";
                        ideVersion = l2;
                    }
                }
            }
            if (ideVersion == null) continue;
            IdeVersion it$iv$iv = ideVersion;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List accessibleVSInstallations2 = (List)destination$iv$iv;
        if (Boolean.parseBoolean(System.getProperty("trl.transfer.ReSharperGranular"))) {
            SwingUtilities.invokeLater(() -> VSWinTransferSettingsProvider.getIdeVersions$lambda$5(speedResult));
        }
        return CollectionsKt.plus((Collection)accessibleVSInstallations2, (Iterable)badVersions);
    }

    @Override
    public boolean isAvailable() {
        return SystemInfoRt.isWindows;
    }

    @Override
    @Nullable
    public Object hasDataToImport(@NotNull Continuation<? super Boolean> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, null){
            int label;
            final /* synthetic */ VSWinTransferSettingsProvider this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return Boxing.boxBoolean((boolean)VSWinTransferSettingsProvider.access$getVsEnumerator$p(this.this$0).hasAny());
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final long timeFn() {
        return System.nanoTime();
    }

    private final long convertTimeFn-5sfh64U(long time) {
        return DurationKt.toDuration((long)time, (DurationUnit)DurationUnit.NANOSECONDS);
    }

    @Override
    @NotNull
    public TransferSettingsRightPanelChooser getRightPanel(@NotNull IdeVersion ideV, @NotNull TransferSettingsConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)ideV, (String)"ideV");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return new VSWinTransferSettingsRightPanelChooser(ideV, config);
    }

    private static final void getIdeVersions$lambda$5(Ref.ObjectRef $speedResult) {
        Intrinsics.checkNotNullParameter((Object)$speedResult, (String)"$speedResult");
        Messages.showInfoMessage((String)((String)$speedResult.element), (String)"Speedrun");
    }

    public static final /* synthetic */ VSPossibleVersionsEnumerator access$getVsEnumerator$p(VSWinTransferSettingsProvider $this) {
        return $this.vsEnumerator;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vswin/VSWinTransferSettingsProvider$VSWinTransferSettingsRightPanelChooser;", "Lcom/intellij/ide/startup/importSettings/ui/representation/TransferSettingsRightPanelChooser;", "ide", "Lcom/intellij/ide/startup/importSettings/models/IdeVersion;", "config", "Lcom/intellij/ide/startup/importSettings/TransferSettingsConfiguration;", "(Lcom/intellij/ide/startup/importSettings/models/IdeVersion;Lcom/intellij/ide/startup/importSettings/TransferSettingsConfiguration;)V", "getBottomComponentFactory", "Lkotlin/Function0;", "Ljavax/swing/JComponent;", "intellij.ide.startup.importSettings"})
    private static final class VSWinTransferSettingsRightPanelChooser
    extends TransferSettingsRightPanelChooser {
        @NotNull
        private final IdeVersion ide;

        public VSWinTransferSettingsRightPanelChooser(@NotNull IdeVersion ide, @NotNull TransferSettingsConfiguration config) {
            Intrinsics.checkNotNullParameter((Object)ide, (String)"ide");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            super(ide, config);
            this.ide = ide;
        }

        @Override
        @NotNull
        public Function0<JComponent> getBottomComponentFactory() {
            return (Function0)new Function0<JComponent>(this){
                final /* synthetic */ VSWinTransferSettingsRightPanelChooser this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final JComponent invoke() {
                    return VSWinTransferSettingsRightPanelChooser.access$getIde$p(this.this$0).getSettingsCache().getPlugins().values().contains(KnownPlugins.INSTANCE.getReSharper()) ? (JComponent)BuilderKt.panel((Function1)getBottomComponentFactory.1.INSTANCE) : null;
                }
            };
        }

        public static final /* synthetic */ IdeVersion access$getIde$p(VSWinTransferSettingsRightPanelChooser $this) {
            return $this.ide;
        }
    }
}

