/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.providers.vswin.parsers.data;

import com.intellij.ide.startup.importSettings.db.KnownPlugins;
import com.intellij.ide.startup.importSettings.models.KeyBinding;
import com.intellij.ide.startup.importSettings.providers.vswin.mappings.KeyBindingsMappings;
import com.intellij.ide.startup.importSettings.providers.vswin.parsers.data.BadKeyBindingException;
import com.intellij.ide.startup.importSettings.providers.vswin.parsers.data.VSParsedData;
import com.intellij.ide.startup.importSettings.providers.vswin.parsers.data.VisualStudioKeyboardShortcut;
import com.intellij.ide.startup.importSettings.providers.vswin.utilities.VSHive;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vswin/parsers/data/KeyBindingsParsedData;", "Lcom/intellij/ide/startup/importSettings/providers/vswin/parsers/data/VSParsedData;", "majorVersion", "", "scheme", "", "userShortcuts", "Lorg/jdom/Element;", "hive", "Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/VSHive;", "(ILjava/lang/String;Lorg/jdom/Element;Lcom/intellij/ide/startup/importSettings/providers/vswin/utilities/VSHive;)V", "isReSharperInstalled", "", "parsedKeyBindings", "", "Lcom/intellij/ide/startup/importSettings/models/KeyBinding;", "reSharperName", "getScheme", "()Ljava/lang/String;", "convertToSettingsFormat", "Companion", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nKeyBindingsParsedData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyBindingsParsedData.kt\ncom/intellij/ide/startup/importSettings/providers/vswin/parsers/data/KeyBindingsParsedData\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,147:1\n372#2,7:148\n11#3:155\n*S KotlinDebug\n*F\n+ 1 KeyBindingsParsedData.kt\ncom/intellij/ide/startup/importSettings/providers/vswin/parsers/data/KeyBindingsParsedData\n*L\n112#1:148,7\n77#1:155\n*E\n"})
public final class KeyBindingsParsedData
implements VSParsedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String scheme;
    @NotNull
    private final List<KeyBinding> parsedKeyBindings;
    private final boolean isReSharperInstalled;
    @NotNull
    private final String reSharperName;
    @NotNull
    public static final String globalScope = "Global";
    @NotNull
    public static final String key = "Environment_KeyBindings";
    @NotNull
    private static final Logger logger;

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public KeyBindingsParsedData(int majorVersion, @NotNull String scheme, @NotNull Element userShortcuts, @Nullable VSHive hive) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)userShortcuts, (String)"userShortcuts");
        super();
        this.scheme = scheme;
        this.parsedKeyBindings = new ArrayList<E>();
        v0 = hive;
        this.isReSharperInstalled = v0 != null && (v0 = v0.getRegistry()) != null && (v0 = v0.getExtensions()) != null && (v0 = v0.values()) != null ? v0.contains(KnownPlugins.INSTANCE.getReSharper()) : false;
        v1 = KnownPlugins.INSTANCE.getReSharper().getName().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toLowerCase(...)");
        this.reSharperName = v1;
        alreadyParsed = new LinkedHashMap<K, V>();
        KeyBindingsParsedData.logger.info("Started parsing shortcuts");
        for (Element shortcutTag : userShortcuts.getChildren()) {
            block15: {
                if (!Intrinsics.areEqual((Object)shortcutTag.getName(), (Object)"Shortcut")) continue;
                v2 = shortcutTag.getAttribute("Scope");
                scope = v2 != null ? v2.getValue() : null;
                v3 = shortcutTag.getAttribute("Command");
                command = v3 != null ? v3.getValue() : null;
                keyboardShortcut = shortcutTag.getValue();
                if (this.isReSharperInstalled) break block15;
                v4 = command;
                if (v4 == null) ** GOTO lbl-1000
                v5 = v4.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"toLowerCase(...)");
                v4 = v5;
                if (v5 != null) {
                    v6 = StringsKt.startsWith$default((String)v4, (String)this.reSharperName, (boolean)false, (int)2, null);
                } else lbl-1000:
                // 2 sources

                {
                    v6 = false;
                }
                if (v6) {
                    KeyBindingsParsedData.logger.info("ReSharper is not installed or disabled, skipping ReSharper shortcuts");
                    continue;
                }
            }
            if (scope == null || command == null) {
                KeyBindingsParsedData.logger.warn("Invalid shortcut where scope or command are null");
                continue;
            }
            KeyBindingsParsedData.logger.debug("Processing " + command);
            if (KeyBindingsMappings.INSTANCE.vsCommandToIdeaAction(command) == null) {
                KeyBindingsParsedData.logger.debug("Unknown action");
                continue;
            }
            $this$getOrPut$iv = alreadyParsed;
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(command);
            if (value$iv == null) {
                $i$a$-getOrPut-KeyBindingsParsedData$mapValue$1 = false;
                answer$iv = new LinkedHashSet<E>();
                $this$getOrPut$iv.put(command, answer$iv);
                v7 /* !! */  = answer$iv;
            } else {
                v7 /* !! */  = value$iv;
            }
            if (!(mapValue = (Set)v7 /* !! */ ).contains(TuplesKt.to((Object)keyboardShortcut, (Object)true))) {
                mapValue.add(TuplesKt.to((Object)keyboardShortcut, (Object)Intrinsics.areEqual((Object)scope, (Object)"Global")));
            }
            if (!Intrinsics.areEqual((Object)scope, (Object)"Global")) continue;
            mapValue.remove(TuplesKt.to((Object)keyboardShortcut, (Object)false));
        }
        for (Map.Entry var7_7 : alreadyParsed.entrySet()) {
            command = (String)var7_7.getKey();
            shortcuts = (Set)var7_7.getValue();
            scArr = new ArrayList<E>();
            convertedAction = KeyBindingsMappings.INSTANCE.vsCommandToIdeaAction(command);
            if (convertedAction == null) {
                KeyBindingsParsedData.logger.warn("convertedaction is null at late stage");
                continue;
            }
            var12_12 = shortcuts.iterator();
            while (var12_12.hasNext()) {
                shortcut = (String)((Pair)var12_12.next()).component1();
                try {
                    sc = new VisualStudioKeyboardShortcut(shortcut, command).getParsed();
                    scArr.add(sc);
                }
                catch (BadKeyBindingException t) {
                    KeyBindingsParsedData.logger.info("parsing error might be not an error");
                    KeyBindingsParsedData.logger.info((Throwable)t);
                }
                catch (Throwable t) {
                    KeyBindingsParsedData.logger.error("Failed to parse shortcut");
                    KeyBindingsParsedData.logger.error(t);
                }
            }
            this.parsedKeyBindings.add(new KeyBinding(convertedAction, scArr, null, 4, null));
        }
    }

    @NotNull
    public final String getScheme() {
        return this.scheme;
    }

    @NotNull
    public final List<KeyBinding> convertToSettingsFormat() {
        return this.parsedKeyBindings;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KeyBindingsParsedData.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        KeyBindingsParsedData.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vswin/parsers/data/KeyBindingsParsedData$Companion;", "", "()V", "globalScope", "", "key", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.ide.startup.importSettings"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

