/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.utils.mpp.time;

import ai.grazie.utils.mpp.MPPComparable;
import ai.grazie.utils.mpp.time.Duration;
import ai.grazie.utils.mpp.time.Time;
import ai.grazie.utils.mpp.time.TimePeriod;
import ai.grazie.utils.mpp.time.TimeUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=Serializer.class)
@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0087\b\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002()B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0000J\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0000J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0000J\u000e\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0000J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0000J\u0011\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\u0006H\u00d6\u0001J\u0011\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u001bH\u0086\u0002J\u0018\u0010\"\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u0006H\u0007J\u0011\u0010%\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u001bH\u0086\u0002J\u0018\u0010%\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u0006H\u0007J\b\u0010&\u001a\u00020'H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u000f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\b\u00a8\u0006*"}, d2={"Lai/grazie/utils/mpp/time/Timestamp;", "Lai/grazie/utils/mpp/MPPComparable;", "millis", "", "(J)V", "days", "", "getDays", "()I", "hours", "getHours", "getMillis", "()J", "minutes", "getMinutes", "seconds", "getSeconds", "after", "", "other", "afterOrEqual", "atStartOf", "period", "Lai/grazie/utils/mpp/time/TimePeriod;", "before", "beforeOrEqual", "between", "Lai/grazie/utils/mpp/time/Duration;", "compareTo", "component1", "copy", "equals", "", "hashCode", "minus", "duration", "number", "plus", "toString", "", "Companion", "Serializer", "utils-common"})
public final class Timestamp
implements MPPComparable<Timestamp> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long millis;

    public Timestamp(long millis) {
        this.millis = millis;
    }

    public final long getMillis() {
        return this.millis;
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.millis);
    }

    public final int getSeconds() {
        return MathKt.roundToInt((double)((double)this.millis / (double)1000));
    }

    public final int getMinutes() {
        return MathKt.roundToInt((double)((double)this.getSeconds() / (double)60));
    }

    public final int getHours() {
        return MathKt.roundToInt((double)((double)this.getMinutes() / (double)60));
    }

    public final int getDays() {
        return MathKt.roundToInt((double)((double)this.getHours() / (double)24));
    }

    @NotNull
    public final Timestamp plus(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return new Timestamp(this.millis + duration.getMillis());
    }

    @NotNull
    public final Timestamp plus(@NotNull TimePeriod period, int number) {
        Intrinsics.checkNotNullParameter((Object)((Object)period), (String)"period");
        return TimeUtils.INSTANCE.plus(this, period, number);
    }

    @NotNull
    public final Timestamp minus(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return new Timestamp(Math.max(0L, this.millis - duration.getMillis()));
    }

    @NotNull
    public final Timestamp minus(@NotNull TimePeriod period, int number) {
        Intrinsics.checkNotNullParameter((Object)((Object)period), (String)"period");
        return TimeUtils.INSTANCE.minus(this, period, number);
    }

    @Override
    public int compareTo(@NotNull Timestamp other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.compare((long)this.millis, (long)other.millis);
    }

    @NotNull
    public final Duration between(@NotNull Timestamp other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Duration(Math.abs(this.millis - other.millis));
    }

    public final boolean before(@NotNull Timestamp other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) < 0;
    }

    public final boolean beforeOrEqual(@NotNull Timestamp other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) <= 0;
    }

    public final boolean after(@NotNull Timestamp other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) >= 0;
    }

    public final boolean afterOrEqual(@NotNull Timestamp other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.millis >= other.millis;
    }

    @NotNull
    public final Timestamp atStartOf(@NotNull TimePeriod period) {
        Intrinsics.checkNotNullParameter((Object)((Object)period), (String)"period");
        return TimeUtils.INSTANCE.atStartOf(this, period);
    }

    public final long component1() {
        return this.millis;
    }

    @NotNull
    public final Timestamp copy(long millis) {
        return new Timestamp(millis);
    }

    public static /* synthetic */ Timestamp copy$default(Timestamp timestamp, long l2, int n, Object object) {
        if ((n & 1) != 0) {
            l2 = timestamp.millis;
        }
        return timestamp.copy(l2);
    }

    public int hashCode() {
        return Long.hashCode(this.millis);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Timestamp)) {
            return false;
        }
        Timestamp timestamp = (Timestamp)other;
        return this.millis == timestamp.millis;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0004J\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u00c6\u0001\u00a8\u0006\u000f"}, d2={"Lai/grazie/utils/mpp/time/Timestamp$Companion;", "", "()V", "epoch", "Lai/grazie/utils/mpp/time/Timestamp;", "max", "now", "of", "millis", "", "ofFullDate", "value", "", "serializer", "Lkotlinx/serialization/KSerializer;", "utils-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Timestamp now() {
            return new Timestamp(Time.INSTANCE.epochMillis$utils_common());
        }

        @NotNull
        public final Timestamp epoch() {
            return new Timestamp(0L);
        }

        @NotNull
        public final Timestamp max() {
            return new Timestamp(Long.MAX_VALUE);
        }

        @NotNull
        public final Timestamp ofFullDate(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return TimeUtils.INSTANCE.ofFullDate(value);
        }

        @NotNull
        public final Timestamp of(double millis) {
            return new Timestamp((long)millis);
        }

        @NotNull
        public final KSerializer<Timestamp> serializer() {
            return Serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lai/grazie/utils/mpp/time/Timestamp$Serializer;", "Lkotlinx/serialization/KSerializer;", "Lai/grazie/utils/mpp/time/Timestamp;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "utils-common"})
    public static final class Serializer
    implements KSerializer<Timestamp> {
        @NotNull
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @NotNull
        public Timestamp deserialize(@NotNull Decoder decoder) {
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            return new Timestamp(decoder.decodeLong());
        }

        @NotNull
        public SerialDescriptor getDescriptor() {
            return SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"Timestamp", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.LONG.INSTANCE));
        }

        public void serialize(@NotNull Encoder encoder, @NotNull Timestamp value) {
            Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            encoder.encodeLong(value.getMillis());
        }
    }
}

