/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jsonProtocol;

import com.google.gson.stream.JsonWriter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtf8Writer;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jsonProtocol.JsonWriters;
import org.jetbrains.jsonProtocol.OutMessageKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\u000eJ\u0016\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J \u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u0017J\u001a\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u001aJ\u0016\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001eJ(\u0010\u001f\u001a\u00020\u000e\"\b\b\u0000\u0010 *\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u0002H \u0018\u00010!J\u0018\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020#H\u0004J\u0018\u0010$\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020%H\u0004J&\u0010&\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0016\b\u0002\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u00010'J\u0018\u0010(\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0000J\u0018\u0010)\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010*J\u0016\u0010+\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020,J\u0018\u0010-\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012J\u001e\u0010.\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006/"}, d2={"Lorg/jetbrains/jsonProtocol/OutMessage;", "", "()V", "buffer", "Lio/netty/buffer/ByteBuf;", "getBuffer", "()Lio/netty/buffer/ByteBuf;", "finalized", "", "writer", "Lcom/google/gson/stream/JsonWriter;", "getWriter", "()Lcom/google/gson/stream/JsonWriter;", "beginArguments", "", "close", "writeDoubleArray", "name", "", "value", "", "writeEnumList", "values", "", "", "writeIntArray", "", "writeIntList", "Lit/unimi/dsi/fastutil/ints/IntList;", "writeIntSet", "Lit/unimi/dsi/fastutil/ints/IntSet;", "writeList", "E", "", "writeLong", "", "writeLongArray", "", "writeMap", "", "writeMessage", "writeNullableString", "", "writeSingletonIntArray", "", "writeString", "writeStringList", "intellij.platform.scriptDebugger.protocolReaderRuntime"})
public class OutMessage {
    @NotNull
    private final ByteBuf buffer;
    @NotNull
    private final JsonWriter writer;
    private boolean finalized;

    public OutMessage() {
        ByteBuf byteBuf = ByteBufAllocator.DEFAULT.buffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"buffer(...)");
        this.buffer = byteBuf;
        this.writer = new JsonWriter((Writer)new ByteBufUtf8Writer(this.buffer));
        this.writer.beginObject();
    }

    @NotNull
    public final ByteBuf getBuffer() {
        return this.buffer;
    }

    @NotNull
    public final JsonWriter getWriter() {
        return this.writer;
    }

    public void beginArguments() {
    }

    public final void writeMap(@NotNull String name, @Nullable Map<String, String> value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value2 == null) {
            return;
        }
        this.beginArguments();
        this.writer.name(name);
        this.writer.beginObject();
        for (Map.Entry<String, String> entry2 : value2.entrySet()) {
            String key2 = entry2.getKey();
            String value1 = entry2.getValue();
            this.writer.name(key2).value(value1);
        }
        this.writer.endObject();
    }

    public static /* synthetic */ void writeMap$default(OutMessage outMessage, String string2, Map map2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeMap");
        }
        if ((n & 2) != 0) {
            map2 = null;
        }
        outMessage.writeMap(string2, map2);
    }

    protected final void writeLongArray(@NotNull String name, @NotNull long[] value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.beginArguments();
        this.writer.name(name);
        this.writer.beginArray();
        for (long v : value2) {
            this.writer.value(v);
        }
        this.writer.endArray();
    }

    public final void writeDoubleArray(@NotNull String name, @NotNull double[] value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.beginArguments();
        this.writer.name(name);
        this.writer.beginArray();
        for (double v : value2) {
            this.writer.value(v);
        }
        this.writer.endArray();
    }

    public final void writeIntArray(@NotNull String name, @Nullable int[] value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value2 == null) {
            return;
        }
        this.beginArguments();
        this.writer.name(name);
        this.writer.beginArray();
        for (int v : value2) {
            this.writer.value((long)v);
        }
        this.writer.endArray();
    }

    public static /* synthetic */ void writeIntArray$default(OutMessage outMessage, String string2, int[] nArray, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeIntArray");
        }
        if ((n & 2) != 0) {
            nArray = null;
        }
        outMessage.writeIntArray(string2, nArray);
    }

    public final void writeIntSet(@NotNull String name, @NotNull IntSet value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.beginArguments();
        this.writer.name(name);
        this.writer.beginArray();
        IntIterator intIterator = value2.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)intIterator, (String)"iterator(...)");
        IntIterator iterator = intIterator;
        while (iterator.hasNext()) {
            this.writer.value((long)iterator.nextInt());
        }
        this.writer.endArray();
    }

    public final void writeIntList(@NotNull String name, @NotNull IntList value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.beginArguments();
        this.writer.name(name);
        this.writer.beginArray();
        int n = value2.size();
        for (int i = 0; i < n; ++i) {
            this.writer.value((long)value2.getInt(i));
        }
        this.writer.endArray();
    }

    public final void writeSingletonIntArray(@NotNull String name, int value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.beginArguments();
        this.writer.name(name);
        this.writer.beginArray();
        this.writer.value((long)value2);
        this.writer.endArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <E extends OutMessage> void writeList(@NotNull String name, @Nullable List<? extends E> value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Collection collection = value2;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        this.beginArguments();
        this.writer.name(name);
        this.writer.beginArray();
        boolean isNotFirst = false;
        for (OutMessage item2 : value2) {
            try {
                if (isNotFirst) {
                    this.buffer.writeByte(44).writeByte(32);
                } else {
                    isNotFirst = true;
                }
                if (!item2.finalized) {
                    item2.finalized = true;
                    try {
                        item2.writer.endObject();
                    }
                    catch (IllegalStateException e) {
                        if (Intrinsics.areEqual((Object)"Nesting problem.", (Object)e.getMessage())) {
                            throw new RuntimeException(item2.buffer.toString(Charsets.UTF_8) + "\nparent:\n" + this.buffer.toString(Charsets.UTF_8), e);
                        }
                        throw e;
                    }
                }
                this.buffer.writeBytes(item2.buffer);
            }
            finally {
                if (item2.buffer.refCnt() <= 0) continue;
                item2.buffer.release();
            }
        }
        this.writer.endArray();
    }

    public final void writeStringList(@NotNull String name, @Nullable Collection<String> value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value2 == null) {
            return;
        }
        this.beginArguments();
        JsonWriters.INSTANCE.writeStringList(this.writer, name, value2);
    }

    public final void writeEnumList(@NotNull String name, @NotNull Collection<? extends Enum<?>> values2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        this.beginArguments();
        this.writer.name(name).beginArray();
        for (Enum<?> item2 : values2) {
            this.writer.value(item2.toString());
        }
        this.writer.endArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeMessage(@NotNull String name, @Nullable OutMessage value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value2 == null) {
            return;
        }
        try {
            this.beginArguments();
            OutMessageKt.prepareWriteRaw(this, name);
            if (!value2.finalized) {
                value2.close();
            }
            this.buffer.writeBytes(value2.buffer);
        }
        finally {
            if (value2.buffer.refCnt() > 0) {
                value2.buffer.release();
            }
        }
    }

    public final void close() {
        boolean bl;
        boolean bl2 = bl = !this.finalized;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.finalized = true;
        this.writer.endObject();
        this.writer.close();
    }

    protected final void writeLong(@NotNull String name, long value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.beginArguments();
        this.writer.name(name).value(value2);
    }

    public final void writeString(@NotNull String name, @Nullable String value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value2 != null) {
            this.writeNullableString(name, value2);
        }
    }

    public final void writeNullableString(@NotNull String name, @Nullable CharSequence value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.beginArguments();
        CharSequence charSequence = value2;
        this.writer.name(name).value(charSequence != null ? ((Object)charSequence).toString() : null);
    }
}

