/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection.custom;

import com.intellij.find.FindBundle;
import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ExtensionsKt;
import com.intellij.ui.dsl.builder.IntelliJSpacingConfiguration;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.gridLayout.HorizontalAlign;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.ui.dsl.gridLayout.VerticalAlign;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.RegExpFileType;
import org.intellij.lang.regexp.inspection.custom.RegExpDialog;
import org.intellij.lang.regexp.inspection.custom.RegExpInspectionConfiguration;
import org.intellij.lang.regexp.inspection.custom.RegExpSample;
import org.intellij.lang.regexp.inspection.custom.RegExpSampleTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u00042345B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010'\u001a\u00020(H\u0014J\u000e\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u0005J\b\u0010+\u001a\u00020(H\u0002J\b\u0010,\u001a\u00020-H\u0014J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/intellij/lang/regexp/inspection/custom/RegExpDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "editConfiguration", "", "defaultPattern", "Lorg/intellij/lang/regexp/inspection/custom/RegExpInspectionConfiguration$InspectionPattern;", "(Lcom/intellij/openapi/project/Project;ZLorg/intellij/lang/regexp/inspection/custom/RegExpInspectionConfiguration$InspectionPattern;)V", "getEditConfiguration", "()Z", "fileCombo", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/openapi/fileTypes/FileType;", "filterButton", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "pattern", "getPattern", "()Lorg/intellij/lang/regexp/inspection/custom/RegExpInspectionConfiguration$InspectionPattern;", "getProject", "()Lcom/intellij/openapi/project/Project;", "value", "replace", "setReplace", "(Z)V", "replaceButton", "Ljavax/swing/JButton;", "replaceEditor", "Lcom/intellij/ui/EditorTextField;", "replaceEditorFocusedLast", "replaceLabel", "Ljavax/swing/JLabel;", "replaceRow", "Lcom/intellij/ui/dsl/builder/Row;", "searchContext", "Lcom/intellij/find/FindModel$SearchContext;", "searchEditor", "splitter", "Lcom/intellij/ui/OnePixelSplitter;", "createCenterPanel", "Ljavax/swing/JComponent;", "createEditor", "search", "createEditorsPanel", "getStyle", "Lcom/intellij/openapi/ui/DialogWrapper$DialogStyle;", "insertSample", "", "sample", "Lorg/intellij/lang/regexp/inspection/custom/RegExpSample;", "MyEditorTextField", "MyFilterAction", "MyToggleAction", "SimpleTypeRenderer", "intellij.regexp"})
@SourceDebugExtension(value={"SMAP\nRegExpDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegExpDialog.kt\norg/intellij/lang/regexp/inspection/custom/RegExpDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,271:1\n1#2:272\n*E\n"})
public final class RegExpDialog
extends DialogWrapper {
    @Nullable
    private final Project project;
    private final boolean editConfiguration;
    @NotNull
    private FindModel.SearchContext searchContext;
    private boolean replace;
    private boolean replaceEditorFocusedLast;
    private ComboBox<FileType> fileCombo;
    private ActionButton filterButton;
    private EditorTextField searchEditor;
    private JLabel replaceLabel;
    private JButton replaceButton;
    private Row replaceRow;
    private EditorTextField replaceEditor;
    private OnePixelSplitter splitter;

    public RegExpDialog(@Nullable Project project2, boolean editConfiguration, @Nullable RegExpInspectionConfiguration.InspectionPattern defaultPattern) {
        super(project2, true);
        this.project = project2;
        this.editConfiguration = editConfiguration;
        this.searchContext = FindModel.SearchContext.ANY;
        this.setTitle(RegExpBundle.message("regexp.dialog.title", new Object[0]));
        this.init();
        if (!this.editConfiguration) {
            this.setModal(false);
        }
        RegExpInspectionConfiguration.InspectionPattern inspectionPattern = defaultPattern;
        if (inspectionPattern != null) {
            FileType fileType;
            RegExpInspectionConfiguration.InspectionPattern pattern2 = inspectionPattern;
            boolean bl = false;
            EditorTextField editorTextField = this.searchEditor;
            if (editorTextField == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"searchEditor");
                editorTextField = null;
            }
            editorTextField.setText(pattern2.regExp);
            FindModel.SearchContext searchContext = pattern2.searchContext;
            Intrinsics.checkNotNullExpressionValue((Object)searchContext, (String)"searchContext");
            this.searchContext = searchContext;
            ComboBox<FileType> comboBox = this.fileCombo;
            if (comboBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fileCombo");
                comboBox = null;
            }
            if ((fileType = pattern2.fileType()) == null) {
                fileType = UnknownFileType.INSTANCE;
            }
            comboBox.setItem((Object)fileType);
            String string2 = pattern2.replacement;
            if (string2 != null) {
                String it = string2;
                boolean bl2 = false;
                EditorTextField editorTextField2 = this.replaceEditor;
                if (editorTextField2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"replaceEditor");
                    editorTextField2 = null;
                }
                editorTextField2.setText(it);
            }
        }
        RegExpInspectionConfiguration.InspectionPattern inspectionPattern2 = defaultPattern;
        this.setReplace((inspectionPattern2 != null ? inspectionPattern2.replacement : null) != null);
    }

    public /* synthetic */ RegExpDialog(Project project2, boolean bl, RegExpInspectionConfiguration.InspectionPattern inspectionPattern, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            inspectionPattern = null;
        }
        this(project2, bl, inspectionPattern);
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    public final boolean getEditConfiguration() {
        return this.editConfiguration;
    }

    private final void setReplace(boolean value2) {
        String string2;
        boolean bl;
        this.replace = value2;
        JLabel jLabel = this.replaceLabel;
        if (jLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"replaceLabel");
            jLabel = null;
        }
        jLabel.setEnabled(value2);
        Row row2 = this.replaceRow;
        if (row2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"replaceRow");
            row2 = null;
        }
        row2.enabled(value2);
        JButton jButton = this.replaceButton;
        if (jButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"replaceButton");
            jButton = null;
        }
        if (bl = value2) {
            string2 = RegExpBundle.message("button.search.only", new Object[0]);
        } else if (!bl) {
            string2 = RegExpBundle.message("button.enable.replace", new Object[0]);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        jButton.setText(string2);
        if (!this.editConfiguration) {
            String string3;
            bl = value2;
            if (bl) {
                string3 = FindBundle.message((String)"find.replace.command", (Object[])new Object[0]);
            } else if (!bl) {
                string3 = FindBundle.message((String)"find.dialog.find.button", (Object[])new Object[0]);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            this.setOKButtonText(string3);
        }
    }

    @NotNull
    public final RegExpInspectionConfiguration.InspectionPattern getPattern() {
        String string2;
        EditorTextField editorTextField = this.searchEditor;
        if (editorTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchEditor");
            editorTextField = null;
        }
        String string3 = editorTextField.getText();
        ComboBox<FileType> comboBox = this.fileCombo;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fileCombo");
            comboBox = null;
        }
        FileType fileType = (FileType)comboBox.getItem();
        if (this.replace) {
            EditorTextField editorTextField2 = this.replaceEditor;
            if (editorTextField2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"replaceEditor");
                editorTextField2 = null;
            }
            string2 = editorTextField2.getText();
        } else {
            string2 = null;
        }
        return new RegExpInspectionConfiguration.InspectionPattern(string3, fileType, this.searchContext, string2);
    }

    private final JComponent createEditorsPanel() {
        return (JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ RegExpDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                IntelliJSpacingConfiguration intelliJSpacingConfiguration = new IntelliJSpacingConfiguration();
                $this$panel.panel((Function1)new Function1<Panel, Unit>(this.this$0){
                    final /* synthetic */ RegExpDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$panel) {
                        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                        Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ RegExpDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull Row $this$row) {
                                void $this$filterTo$iv$iv;
                                void $this$filter$iv;
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                String string2 = RegExpBundle.message("regexp.dialog.search.template", new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                                $this$row.label(string2).resizableColumn().horizontalAlign(HorizontalAlign.FILL);
                                Object[] objectArray = new FileType[]{UnknownFileType.INSTANCE};
                                List fileTypes = CollectionsKt.mutableListOf((Object[])objectArray);
                                FileType[] fileTypeArray = FileTypeManager.getInstance().getRegisteredFileTypes();
                                Intrinsics.checkNotNullExpressionValue((Object)fileTypeArray, (String)"getRegisteredFileTypes(...)");
                                Iterable $this$sortedBy$iv = ArraysKt.filterNotNull((Object[])fileTypeArray);
                                boolean $i$f$sortedBy = false;
                                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                                    public final int compare(T a, T b) {
                                        FileType it = (FileType)a;
                                        boolean bl = false;
                                        Comparable comparable = (Comparable)((Object)it.getDisplayName());
                                        it = (FileType)b;
                                        Comparable comparable2 = comparable;
                                        bl = false;
                                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getDisplayName())));
                                    }
                                });
                                List list2 = fileTypes;
                                boolean $i$f$filter = false;
                                void var5_6 = $this$filter$iv;
                                Collection destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$filterTo = false;
                                for (T element$iv$iv : $this$filterTo$iv$iv) {
                                    FileType it = (FileType)element$iv$iv;
                                    boolean bl = false;
                                    if (!(!Intrinsics.areEqual((Object)it, (Object)UnknownFileType.INSTANCE))) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                list2.addAll((List)destination$iv$iv);
                                Cell cell = $this$row.comboBox((Collection)fileTypes, (ListCellRenderer)((Object)this.this$0.new SimpleTypeRenderer()));
                                String string3 = RegExpBundle.message("regexp.dialog.language", new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                                RegExpDialog.access$setFileCombo$p(this.this$0, (ComboBox)Cell.label$default((Cell)cell, (String)string3, null, (int)2, null).applyToComponent((Function1)createEditorsPanel.3.INSTANCE).gap(RightGap.SMALL).getComponent());
                                RegExpDialog.access$setFilterButton$p(this.this$0, (ActionButton)ExtensionsKt.actionButton$default((Row)$this$row, (AnAction)((AnAction)this.this$0.new MyFilterAction()), null, (int)2, null).getComponent());
                            }
                        }), (int)1, null);
                    }
                }).customize(UnscaledGapsKt.UnscaledGaps((int)0, (int)intelliJSpacingConfiguration.getHorizontalIndent(), (int)0, (int)intelliJSpacingConfiguration.getHorizontalIndent()));
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ RegExpDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        RegExpDialog.access$setSearchEditor$p(this.this$0, (EditorTextField)$this$row.cell((JComponent)this.this$0.createEditor(true)).resizableColumn().horizontalAlign(HorizontalAlign.FILL).verticalAlign(VerticalAlign.FILL).applyToComponent((Function1)new Function1<EditorTextField, Unit>(this.this$0){
                            final /* synthetic */ RegExpDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull EditorTextField $this$applyToComponent) {
                                Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
                                $this$applyToComponent.addFocusListener((FocusListener)new FocusAdapter(this.this$0){
                                    final /* synthetic */ RegExpDialog this$0;
                                    {
                                        this.this$0 = $receiver;
                                    }

                                    public void focusGained(@Nullable FocusEvent e) {
                                        RegExpDialog.access$setReplaceEditorFocusedLast$p(this.this$0, false);
                                    }
                                });
                            }
                        }).getComponent());
                    }
                }), (int)1, null).resizableRow();
                $this$panel.panel((Function1)new Function1<Panel, Unit>(this.this$0){
                    final /* synthetic */ RegExpDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$panel) {
                        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                        Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ RegExpDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                String string2 = RegExpBundle.message("regexp.dialog.replace.template", new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                                RegExpDialog.access$setReplaceLabel$p(this.this$0, (JLabel)$this$row.label(string2).resizableColumn().horizontalAlign(HorizontalAlign.FILL).getComponent());
                                String string3 = RegExpDialog.access$getReplace$p(this.this$0) ? RegExpBundle.message("button.search.only", new Object[0]) : RegExpBundle.message("button.enable.replace", new Object[0]);
                                Intrinsics.checkNotNull((Object)string3);
                                RegExpDialog.access$setReplaceButton$p(this.this$0, (JButton)$this$row.button(string3, (Function1)new Function1<ActionEvent, Unit>(this.this$0){
                                    final /* synthetic */ RegExpDialog this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull ActionEvent it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        RegExpDialog.access$setReplace(this.this$0, !RegExpDialog.access$getReplace$p(this.this$0));
                                    }
                                }).getComponent());
                            }
                        }), (int)1, null);
                    }
                }).customize(UnscaledGapsKt.UnscaledGaps((int)10, (int)intelliJSpacingConfiguration.getHorizontalIndent(), (int)0, (int)intelliJSpacingConfiguration.getHorizontalIndent()));
                RegExpDialog.access$setReplaceRow$p(this.this$0, Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ RegExpDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        RegExpDialog.access$setReplaceEditor$p(this.this$0, (EditorTextField)$this$row.cell((JComponent)this.this$0.createEditor(false)).resizableColumn().horizontalAlign(HorizontalAlign.FILL).verticalAlign(VerticalAlign.FILL).applyToComponent((Function1)new Function1<EditorTextField, Unit>(this.this$0){
                            final /* synthetic */ RegExpDialog this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull EditorTextField $this$applyToComponent) {
                                Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
                                $this$applyToComponent.addFocusListener((FocusListener)new FocusAdapter(this.this$0){
                                    final /* synthetic */ RegExpDialog this$0;
                                    {
                                        this.this$0 = $receiver;
                                    }

                                    public void focusGained(@Nullable FocusEvent e) {
                                        RegExpDialog.access$setReplaceEditorFocusedLast$p(this.this$0, true);
                                    }
                                });
                            }
                        }).getComponent());
                    }
                }), (int)1, null).resizableRow());
            }
        }));
    }

    @NotNull
    protected JComponent createCenterPanel() {
        this.splitter = new OnePixelSplitter();
        OnePixelSplitter onePixelSplitter = this.splitter;
        if (onePixelSplitter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"splitter");
            onePixelSplitter = null;
        }
        onePixelSplitter.setFirstComponent(new RegExpSampleTree((Function1<? super RegExpSample, Unit>)((Function1)new Function1<RegExpSample, Unit>(this){
            final /* synthetic */ RegExpDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull RegExpSample it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                RegExpDialog.access$insertSample(this.this$0, it);
            }
        })).getPanel());
        OnePixelSplitter onePixelSplitter2 = this.splitter;
        if (onePixelSplitter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"splitter");
            onePixelSplitter2 = null;
        }
        onePixelSplitter2.setSecondComponent(this.createEditorsPanel());
        EditorTextField editorTextField = this.searchEditor;
        if (editorTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchEditor");
            editorTextField = null;
        }
        editorTextField.grabFocus();
        OnePixelSplitter onePixelSplitter3 = this.splitter;
        if (onePixelSplitter3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"splitter");
            onePixelSplitter3 = null;
        }
        return (JComponent)onePixelSplitter3;
    }

    private final void insertSample(RegExpSample sample) {
        EditorTextField editorTextField;
        if (this.replaceEditorFocusedLast) {
            editorTextField = this.replaceEditor;
            if (editorTextField == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"replaceEditor");
                editorTextField = null;
            }
        } else {
            editorTextField = this.searchEditor;
            if (editorTextField == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"searchEditor");
                editorTextField = null;
            }
        }
        EditorTextField editor = editorTextField;
        List list2 = editor.getCaretModel().getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllCarets(...)");
        Caret caret = (Caret)CollectionsKt.firstOrNull((List)list2);
        if (caret == null) {
            return;
        }
        Caret caret2 = caret;
        int insertOffset = caret2.getOffset();
        int sampleOffset = sample.getCaretOffset() == -1 ? sample.getSample().length() : sample.getCaretOffset();
        boolean bl = caret2.hasSelection();
        if (bl) {
            String string2 = caret2.getSelectedText();
            Intrinsics.checkNotNull((Object)string2);
            String selection = string2;
            String string3 = editor.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            String start2 = StringsKt.dropLast((String)string3, (int)(editor.getText().length() - caret2.getSelectionStart()));
            String string4 = editor.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
            String end = StringsKt.drop((String)string4, (int)caret2.getSelectionEnd());
            String sampleStart = StringsKt.dropLast((String)sample.getSample(), (int)(sample.getSample().length() - sampleOffset));
            String sampleEnd = StringsKt.drop((String)sample.getSample(), (int)sampleOffset);
            editor.setText(start2 + sampleStart + selection + sampleEnd + end);
            caret2.moveToOffset(caret2.getSelectionStart() + sampleStart.length() + selection.length());
        } else if (!bl) {
            String string5 = editor.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getText(...)");
            String start3 = StringsKt.dropLast((String)string5, (int)(editor.getText().length() - insertOffset));
            String string6 = editor.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getText(...)");
            String end = StringsKt.drop((String)string6, (int)insertOffset);
            editor.setText(start3 + sample.getSample() + end);
            caret2.moveToOffset(caret2.getOffset() + sampleOffset);
        }
        editor.grabFocus();
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        return DialogWrapper.DialogStyle.COMPACT;
    }

    @NotNull
    public final EditorTextField createEditor(boolean search2) {
        MyEditorTextField myEditorTextField;
        Document document2 = EditorFactory.getInstance().createDocument((CharSequence)"");
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"createDocument(...)");
        Document document3 = document2;
        MyEditorTextField $this$createEditor_u24lambda_u242 = myEditorTextField = new MyEditorTextField(document3, search2);
        boolean bl = false;
        $this$createEditor_u24lambda_u242.setFont(EditorFontType.getGlobalPlainFont());
        $this$createEditor_u24lambda_u242.setPreferredSize(new Dimension(550, 100));
        return myEditorTextField;
    }

    public static final /* synthetic */ void access$setFileCombo$p(RegExpDialog $this, ComboBox comboBox) {
        $this.fileCombo = comboBox;
    }

    public static final /* synthetic */ void access$setFilterButton$p(RegExpDialog $this, ActionButton actionButton) {
        $this.filterButton = actionButton;
    }

    public static final /* synthetic */ void access$setSearchEditor$p(RegExpDialog $this, EditorTextField editorTextField) {
        $this.searchEditor = editorTextField;
    }

    public static final /* synthetic */ void access$setReplaceEditorFocusedLast$p(RegExpDialog $this, boolean bl) {
        $this.replaceEditorFocusedLast = bl;
    }

    public static final /* synthetic */ void access$setReplaceLabel$p(RegExpDialog $this, JLabel jLabel) {
        $this.replaceLabel = jLabel;
    }

    public static final /* synthetic */ void access$setReplaceButton$p(RegExpDialog $this, JButton jButton) {
        $this.replaceButton = jButton;
    }

    public static final /* synthetic */ boolean access$getReplace$p(RegExpDialog $this) {
        return $this.replace;
    }

    public static final /* synthetic */ void access$setReplace(RegExpDialog $this, boolean value2) {
        $this.setReplace(value2);
    }

    public static final /* synthetic */ void access$setReplaceRow$p(RegExpDialog $this, Row row2) {
        $this.replaceRow = row2;
    }

    public static final /* synthetic */ void access$setReplaceEditor$p(RegExpDialog $this, EditorTextField editorTextField) {
        $this.replaceEditor = editorTextField;
    }

    public static final /* synthetic */ void access$insertSample(RegExpDialog $this, RegExpSample sample) {
        $this.insertSample(sample);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/intellij/lang/regexp/inspection/custom/RegExpDialog$MyEditorTextField;", "Lcom/intellij/ui/EditorTextField;", "document", "Lcom/intellij/openapi/editor/Document;", "search", "", "(Lorg/intellij/lang/regexp/inspection/custom/RegExpDialog;Lcom/intellij/openapi/editor/Document;Z)V", "getSearch", "()Z", "createEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "intellij.regexp"})
    private final class MyEditorTextField
    extends EditorTextField {
        private final boolean search;

        public MyEditorTextField(Document document2, boolean search2) {
            Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
            super(document2, RegExpDialog.this.getProject(), (FileType)RegExpFileType.INSTANCE, false, false);
            this.search = search2;
        }

        public final boolean getSearch() {
            return this.search;
        }

        @NotNull
        protected EditorEx createEditor() {
            EditorEx editorEx;
            EditorEx editorEx2 = super.createEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editorEx2, (String)"createEditor(...)");
            EditorEx $this$createEditor_u24lambda_u240 = editorEx = editorEx2;
            boolean bl = false;
            $this$createEditor_u24lambda_u240.setHorizontalScrollbarVisible(true);
            $this$createEditor_u24lambda_u240.setVerticalScrollbarVisible(true);
            Border border = JBUI.Borders.customLine((Color)JBColor.border(), (int)1, (int)0, (int)(this.search ? 1 : 0), (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)border, (String)"customLine(...)");
            Border outerBorder = border;
            $this$createEditor_u24lambda_u240.getScrollPane().setBorder(new CompoundBorder(outerBorder, (Border)JBUI.Borders.empty((int)6, (int)8, (int)6, (int)8)));
            $this$createEditor_u24lambda_u240.setEmbeddedIntoDialogWrapper(true);
            return editorEx;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/intellij/lang/regexp/inspection/custom/RegExpDialog$MyFilterAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "(Lorg/intellij/lang/regexp/inspection/custom/RegExpDialog;)V", "listPopup", "Lcom/intellij/openapi/ui/popup/ListPopup;", "getListPopup", "()Lcom/intellij/openapi/ui/popup/ListPopup;", "setListPopup", "(Lcom/intellij/openapi/ui/popup/ListPopup;)V", "myGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getMyGroup", "()Lcom/intellij/openapi/actionSystem/ActionGroup;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.regexp"})
    @SourceDebugExtension(value={"SMAP\nRegExpDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegExpDialog.kt\norg/intellij/lang/regexp/inspection/custom/RegExpDialog$MyFilterAction\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,271:1\n13309#2,2:272\n*S KotlinDebug\n*F\n+ 1 RegExpDialog.kt\norg/intellij/lang/regexp/inspection/custom/RegExpDialog$MyFilterAction\n*L\n245#1:272,2\n*E\n"})
    private final class MyFilterAction
    extends DumbAwareAction {
        @NotNull
        private final ActionGroup myGroup;
        @Nullable
        private ListPopup listPopup;

        /*
         * WARNING - void declaration
         */
        public MyFilterAction() {
            void $this$_init__u24lambda_u242;
            KeyboardShortcut it;
            super(FindBundle.messagePointer((String)"find.popup.show.filter.popup", (Object[])new Object[0]), Presentation.NULL_STRING, AllIcons.General.Filter);
            KeyboardShortcut keyboardShortcut = ActionManager.getInstance().getKeyboardShortcut("ShowFilterPopup");
            if (keyboardShortcut != null) {
                it = keyboardShortcut;
                boolean bl = false;
                Shortcut[] shortcutArray = new Shortcut[]{it};
                this.setShortcutSet((ShortcutSet)new CustomShortcutSet(shortcutArray));
            }
            DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
            RegExpDialog regExpDialog = RegExpDialog.this;
            it = defaultActionGroup;
            MyFilterAction myFilterAction = this;
            boolean bl = false;
            FindModel.SearchContext[] $this$forEach$iv = FindModel.SearchContext.values();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                FindModel.SearchContext element$iv;
                FindModel.SearchContext it2 = element$iv = $this$forEach$iv[i];
                boolean bl2 = false;
                $this$_init__u24lambda_u242.add((AnAction)regExpDialog.new MyToggleAction(it2, this));
            }
            $this$_init__u24lambda_u242.setPopup(true);
            myFilterAction.myGroup = (ActionGroup)defaultActionGroup;
        }

        @NotNull
        public final ActionGroup getMyGroup() {
            return this.myGroup;
        }

        @Nullable
        public final ListPopup getListPopup() {
            return this.listPopup;
        }

        public final void setListPopup(@Nullable ListPopup listPopup) {
            this.listPopup = listPopup;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ListPopup listPopup = this.listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, this.myGroup, e.getDataContext(), false, null, 10);
                if (listPopup == null) break block1;
                ActionButton actionButton = RegExpDialog.this.filterButton;
                if (actionButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"filterButton");
                    actionButton = null;
                }
                listPopup.showUnderneathOf((Component)actionButton);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0010H\u0016R\u0015\u0010\u0005\u001a\u00060\u0006R\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/intellij/lang/regexp/inspection/custom/RegExpDialog$MyToggleAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "context", "Lcom/intellij/find/FindModel$SearchContext;", "action", "Lorg/intellij/lang/regexp/inspection/custom/RegExpDialog$MyFilterAction;", "Lorg/intellij/lang/regexp/inspection/custom/RegExpDialog;", "(Lorg/intellij/lang/regexp/inspection/custom/RegExpDialog;Lcom/intellij/find/FindModel$SearchContext;Lorg/intellij/lang/regexp/inspection/custom/RegExpDialog$MyFilterAction;)V", "getAction", "()Lorg/intellij/lang/regexp/inspection/custom/RegExpDialog$MyFilterAction;", "getContext", "()Lcom/intellij/find/FindModel$SearchContext;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.regexp"})
    private final class MyToggleAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final FindModel.SearchContext context;
        @NotNull
        private final MyFilterAction action;

        public MyToggleAction(@NotNull FindModel.SearchContext context, MyFilterAction action2) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)((Object)action2), (String)"action");
            super(FindInProjectUtil.getPresentableName((FindModel.SearchContext)context));
            this.context = context;
            this.action = action2;
        }

        @NotNull
        public final FindModel.SearchContext getContext() {
            return this.context;
        }

        @NotNull
        public final MyFilterAction getAction() {
            return this.action;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return RegExpDialog.this.searchContext == this.context;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            ActionButton actionButton;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            RegExpDialog.this.searchContext = this.context;
            ListPopup listPopup = this.action.getListPopup();
            if (listPopup != null) {
                listPopup.closeOk(null);
            }
            if ((actionButton = RegExpDialog.this.filterButton) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"filterButton");
                actionButton = null;
            }
            actionButton.repaint();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J<\u0010\u0004\u001a\u00020\u00052\u0010\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/lang/regexp/inspection/custom/RegExpDialog$SimpleTypeRenderer;", "Lcom/intellij/ui/SimpleListCellRenderer;", "Lcom/intellij/openapi/fileTypes/FileType;", "(Lorg/intellij/lang/regexp/inspection/custom/RegExpDialog;)V", "customize", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "intellij.regexp"})
    public final class SimpleTypeRenderer
    extends SimpleListCellRenderer<FileType> {
        public void customize(@NotNull JList<? extends FileType> list2, @Nullable FileType value2, int index, boolean selected, boolean hasFocus) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            if (value2 == null) {
                return;
            }
            if (Intrinsics.areEqual((Object)value2, (Object)UnknownFileType.INSTANCE)) {
                this.setText(RegExpBundle.message("label.any", new Object[0]));
                this.setIcon(AllIcons.FileTypes.Any_type);
            } else {
                this.setText(value2.getDisplayName());
                Icon icon2 = value2.getIcon();
                if (icon2 == null) {
                    icon2 = AllIcons.FileTypes.Text;
                }
                this.setIcon(icon2);
            }
        }
    }
}

