/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.fixes;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SuggestEnumValuesFix
implements LocalQuickFix,
BatchQuickFix {
    private final JsonLikeSyntaxAdapter myQuickFixAdapter;

    public SuggestEnumValuesFix(JsonLikeSyntaxAdapter quickFixAdapter) {
        this.myQuickFixAdapter = quickFixAdapter;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string2 = JsonBundle.message("replace.with.allowed.value", new Object[0]);
        if (string2 == null) {
            SuggestEnumValuesFix.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string2 = this.getFamilyName();
        if (string2 == null) {
            SuggestEnumValuesFix.$$$reportNull$$$0(1);
        }
        return string2;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        boolean isJsonPropName;
        if (project2 == null) {
            SuggestEnumValuesFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            SuggestEnumValuesFix.$$$reportNull$$$0(3);
        }
        PsiElement initialElement = descriptor.getPsiElement();
        PsiElement element = this.myQuickFixAdapter.adjustValue(initialElement);
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project2).getSelectedEditor(element.getContainingFile().getVirtualFile());
        boolean whitespaceBefore = false;
        PsiElement prevPrev = null;
        PsiElement prev = element.getPrevSibling();
        if (prev instanceof PsiWhiteSpace) {
            whitespaceBefore = true;
            prevPrev = prev.getPrevSibling();
        }
        boolean shouldAddWhitespace = this.myQuickFixAdapter.fixWhitespaceBefore(initialElement, element);
        PsiElement parent = element.getParent();
        boolean bl = isJsonPropName = parent instanceof JsonProperty && ((JsonProperty)parent).getNameElement() == element;
        if (isJsonPropName) {
            WriteAction.run(() -> element.replace((PsiElement)new JsonElementGenerator(project2).createStringLiteral("")));
        } else {
            WriteAction.run(() -> element.delete());
        }
        EditorEx editor = EditorUtil.getEditorEx((FileEditor)fileEditor);
        assert (editor != null);
        if ((shouldAddWhitespace |= prevPrev != null && PsiUtilCore.getElementType((PsiElement)prevPrev.getNextSibling()) != TokenType.WHITE_SPACE) && whitespaceBefore) {
            WriteAction.run(() -> {
                int offset = editor.getCaretModel().getOffset();
                editor.getDocument().insertString(offset, (CharSequence)" ");
                editor.getCaretModel().moveToOffset(offset + 1);
            });
        }
        if (isJsonPropName) {
            editor.getCaretModel().moveToOffset(((JsonProperty)parent).getNameElement().getTextOffset() + 1);
        }
        CodeCompletionHandlerBase.createHandler((CompletionType)CompletionType.BASIC).invokeCompletion(project2, (Editor)editor);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project2, CommonProblemDescriptor @NotNull [] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
        Editor editor;
        if (project2 == null) {
            SuggestEnumValuesFix.$$$reportNull$$$0(4);
        }
        if (psiElementsToIgnore == null) {
            SuggestEnumValuesFix.$$$reportNull$$$0(5);
        }
        if (descriptors == null) {
            SuggestEnumValuesFix.$$$reportNull$$$0(6);
        }
        if ((editor = FileEditorManager.getInstance((Project)project2).getSelectedTextEditor()) != null) {
            HintManager.getInstance().showErrorHint(editor, JsonBundle.message("sorry.this.fix.is.not.available.in.batch.mode", new Object[0]));
        } else {
            Messages.showErrorDialog((Project)project2, (String)JsonBundle.message("sorry.this.fix.is.not.available.in.batch.mode", new Object[0]), (String)JsonBundle.message("not.applicable.in.batch.mode", new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/fixes/SuggestEnumValuesFix";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementsToIgnore";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/fixes/SuggestEnumValuesFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 2, 3, 4, 5, 6 -> new IllegalArgumentException(string2);
        };
    }
}

