/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.IfThenElse;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.light.legacy.JsonSchemaObjectReadingUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JsonSchemaObject {
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonSchemaObject)) {
            return false;
        }
        JsonSchemaObject object = (JsonSchemaObject)o;
        return Objects.equals(this.getFileUrl(), object.getFileUrl()) && Objects.equals(this.getPointer(), object.getPointer());
    }

    public int hashCode() {
        return Objects.hash(this.getFileUrl(), this.getPointer());
    }

    public abstract boolean isValidByExclusion();

    @Nullable
    public abstract String resolveId(@NotNull String var1);

    @NotNull
    public abstract String getPointer();

    @Nullable
    public abstract String getFileUrl();

    @Nullable
    public abstract VirtualFile getRawFile();

    public abstract boolean hasPatternProperties();

    @Nullable
    public abstract JsonSchemaType getType();

    @Nullable
    public abstract Number getMultipleOf();

    @Nullable
    public abstract Number getMaximum();

    public abstract boolean isExclusiveMaximum();

    @Nullable
    public abstract Number getExclusiveMaximumNumber();

    @Nullable
    public abstract Number getExclusiveMinimumNumber();

    @Nullable
    public abstract Number getMinimum();

    public abstract boolean isExclusiveMinimum();

    @Nullable
    public abstract Integer getMaxLength();

    @Nullable
    public abstract Integer getMinLength();

    @Nullable
    public abstract String getPattern();

    public abstract boolean getAdditionalPropertiesAllowed();

    public abstract boolean hasOwnExtraPropertyProhibition();

    @Nullable
    public abstract JsonSchemaObject getPropertyNamesSchema();

    @Nullable
    public abstract JsonSchemaObject getAdditionalPropertiesSchema();

    @Nullable
    public abstract Boolean getAdditionalItemsAllowed();

    @Nullable
    public abstract String getDeprecationMessage();

    @Nullable
    public abstract JsonSchemaObject getAdditionalItemsSchema();

    @Nullable
    public abstract JsonSchemaObject getItemsSchema();

    @Nullable
    public abstract JsonSchemaObject getContainsSchema();

    @Nullable
    public abstract List<? extends JsonSchemaObject> getItemsSchemaList();

    @Nullable
    public abstract Integer getMaxItems();

    @Nullable
    public abstract Integer getMinItems();

    public abstract boolean isUniqueItems();

    @Nullable
    public abstract Integer getMaxProperties();

    @Nullable
    public abstract Integer getMinProperties();

    @Nullable
    public abstract Set<String> getRequired();

    @Nullable
    public abstract List<Object> getEnum();

    @Nullable
    public abstract JsonSchemaObject getNot();

    @Nullable
    public abstract List<IfThenElse> getIfThenElse();

    @Nullable
    public abstract Set<JsonSchemaType> getTypeVariants();

    @Nullable
    public abstract String getRef();

    public abstract boolean isRefRecursive();

    public abstract boolean isRecursiveAnchor();

    @Nullable
    public abstract Object getDefault();

    @Nullable
    public abstract JsonSchemaObject getExampleByName(@NotNull String var1);

    @Nullable
    public abstract String getFormat();

    @Nullable
    public abstract String getId();

    @Nullable
    public abstract String getSchema();

    @Nullable
    public abstract String getDescription();

    @Nullable
    public abstract String getTitle();

    @Nullable
    public abstract JsonSchemaObject getMatchingPatternPropertySchema(@NotNull String var1);

    public abstract boolean checkByPattern(@NotNull String var1);

    @Nullable
    public abstract String getPatternError();

    @Nullable
    public abstract JsonSchemaObject findRelativeDefinition(@NotNull String var1);

    @Nullable
    public abstract Map<String, Map<String, String>> getEnumMetadata();

    @Nullable
    public abstract Map<String, List<String>> getPropertyDependencies();

    @Nullable
    public abstract JsonSchemaObject getDefinitionByName(@NotNull String var1);

    @NotNull
    public abstract Iterator<String> getDefinitionNames();

    @Nullable
    public abstract String readChildNodeValue(String ... var1);

    public abstract boolean hasChildNode(String ... var1);

    @NotNull
    public abstract Iterator<String> getPropertyNames();

    @Nullable
    public abstract JsonSchemaObject getPropertyByName(@NotNull String var1);

    @NotNull
    public abstract Iterator<String> getSchemaDependencyNames();

    @Nullable
    public abstract JsonSchemaObject getSchemaDependencyByName(@NotNull String var1);

    @Nullable
    public abstract List<? extends JsonSchemaObject> getAllOf();

    @Nullable
    public abstract List<? extends JsonSchemaObject> getAnyOf();

    @Nullable
    public abstract List<? extends JsonSchemaObject> getOneOf();

    @Deprecated
    @Nullable
    public abstract Map<String, ? extends JsonSchemaObject> getSchemaDependencies();

    @Deprecated
    @Nullable
    public String getTypeDescription(boolean shortDesc) {
        return JsonSchemaObjectReadingUtils.getTypeDescription(this, shortDesc);
    }

    @Deprecated
    public boolean hasStringChecks() {
        return JsonSchemaObjectReadingUtils.hasStringChecks(this);
    }

    @Deprecated
    public boolean hasNumericChecks() {
        return JsonSchemaObjectReadingUtils.hasNumericChecks(this);
    }

    @Deprecated
    public boolean hasArrayChecks() {
        return JsonSchemaObjectReadingUtils.hasArrayChecks(this);
    }

    @Deprecated
    public boolean hasObjectChecks() {
        return JsonSchemaObjectReadingUtils.hasObjectChecks(this);
    }

    @Deprecated
    @Nullable
    public abstract String getHtmlDescription();

    @Deprecated
    @NotNull
    public abstract Map<String, ? extends JsonSchemaObject> getProperties();

    @Deprecated
    @Nullable
    public abstract JsonSchemaObject getBackReference();

    @Deprecated
    @Nullable
    public abstract Map<String, Object> getExample();

    @Deprecated
    public abstract boolean isForceCaseInsensitive();

    @Deprecated
    @Nullable
    public abstract String getLanguageInjection();

    @Deprecated
    @Nullable
    public abstract String getLanguageInjectionPrefix();

    @Deprecated
    @Nullable
    public abstract String getLanguageInjectionPostfix();

    @Deprecated
    public abstract boolean isShouldValidateAgainstJSType();

    @Deprecated
    @Nullable
    public abstract Map<String, ? extends JsonSchemaObject> getDefinitionsMap();

    @Deprecated
    @Nullable
    public abstract JsonSchemaObject resolveRefSchema(@NotNull JsonSchemaService var1);

    @Deprecated
    @Nullable
    public abstract JsonSchemaType mergeTypes(@Nullable JsonSchemaType var1, @Nullable JsonSchemaType var2, @Nullable Set<JsonSchemaType> var3);

    @Deprecated
    public abstract Set<JsonSchemaType> mergeTypeVariantSets(@Nullable Set<JsonSchemaType> var1, @Nullable Set<JsonSchemaType> var2);

    @Deprecated
    public abstract void mergeValues(@NotNull JsonSchemaObject var1);
}

