/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.diff.DiffContentFactoryImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.IgnoredFileGenerator;
import com.intellij.openapi.vcs.util.paths.RecursiveFilePathSet;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.vcsUtil.VcsUtil;
import java.nio.charset.Charset;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public final class VcsImplUtil {
    private static final Logger LOG = Logger.getInstance(VcsImplUtil.class);

    public static void showErrorMessage(Project project2, @NlsContexts.DialogMessage String message2, @NlsContexts.DialogTitle String title2) {
        Runnable task2 = () -> Messages.showErrorDialog((Project)project2, (String)message2, (String)title2);
        WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)task2, null, (Project)project2);
    }

    @NlsSafe
    @NotNull
    public static String getShortVcsRootName(@NotNull Project project2, @NotNull VirtualFile root) {
        if (project2 == null) {
            VcsImplUtil.$$$reportNull$$$0(0);
        }
        if (root == null) {
            VcsImplUtil.$$$reportNull$$$0(1);
        }
        String string2 = VcsUtil.getShortVcsRootName(project2, root);
        if (string2 == null) {
            VcsImplUtil.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Nullable
    public static IgnoredFileContentProvider findIgnoredFileContentProvider(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            VcsImplUtil.$$$reportNull$$$0(3);
        }
        return VcsImplUtil.findIgnoredFileContentProvider(vcs.getProject(), vcs.getKeyInstanceMethod());
    }

    @Nullable
    public static IgnoredFileContentProvider findIgnoredFileContentProvider(@NotNull Project project2, @NotNull VcsKey vcsKey) {
        if (project2 == null) {
            VcsImplUtil.$$$reportNull$$$0(4);
        }
        if (vcsKey == null) {
            VcsImplUtil.$$$reportNull$$$0(5);
        }
        IgnoredFileContentProvider ignoreContentProvider = null;
        for (IgnoredFileContentProvider provider2 : IgnoredFileContentProvider.IGNORE_FILE_CONTENT_PROVIDER.getExtensionList((AreaInstance)project2)) {
            if (!provider2.getSupportedVcs().equals(vcsKey)) continue;
            ignoreContentProvider = provider2;
            break;
        }
        if (ignoreContentProvider == null) {
            LOG.debug("Cannot get ignore content provider for vcs " + vcsKey.getName());
            return null;
        }
        return ignoreContentProvider;
    }

    public static void proposeUpdateIgnoreFile(@NotNull Project project2, @NotNull AbstractVcs vcs, @NotNull VirtualFile ignoreFileRoot) {
        if (project2 == null) {
            VcsImplUtil.$$$reportNull$$$0(6);
        }
        if (vcs == null) {
            VcsImplUtil.$$$reportNull$$$0(7);
        }
        if (ignoreFileRoot == null) {
            VcsImplUtil.$$$reportNull$$$0(8);
        }
        VcsImplUtil.generateIgnoreFile(project2, vcs, ignoreFileRoot, true);
    }

    public static void generateIgnoreFileIfNeeded(@NotNull Project project2, @NotNull AbstractVcs vcs, @NotNull VirtualFile ignoreFileRoot) {
        if (project2 == null) {
            VcsImplUtil.$$$reportNull$$$0(9);
        }
        if (vcs == null) {
            VcsImplUtil.$$$reportNull$$$0(10);
        }
        if (ignoreFileRoot == null) {
            VcsImplUtil.$$$reportNull$$$0(11);
        }
        VcsImplUtil.generateIgnoreFile(project2, vcs, ignoreFileRoot, false);
    }

    private static void generateIgnoreFile(@NotNull Project project2, @NotNull AbstractVcs vcs, @NotNull VirtualFile ignoreFileRoot, boolean notify) {
        IgnoredFileGenerator ignoredFileGenerator;
        if (project2 == null) {
            VcsImplUtil.$$$reportNull$$$0(12);
        }
        if (vcs == null) {
            VcsImplUtil.$$$reportNull$$$0(13);
        }
        if (ignoreFileRoot == null) {
            VcsImplUtil.$$$reportNull$$$0(14);
        }
        if ((ignoredFileGenerator = (IgnoredFileGenerator)project2.getService(IgnoredFileGenerator.class)) == null) {
            LOG.debug("Cannot find ignore file ignoredFileGenerator for " + vcs.getName() + " VCS");
            return;
        }
        ignoredFileGenerator.generateFile(ignoreFileRoot, vcs, notify);
    }

    private static boolean isFileSharedInVcs(@NotNull Project project2, @NotNull ChangeListManager changeListManager, @NotNull String filePath) {
        VirtualFile file;
        if (project2 == null) {
            VcsImplUtil.$$$reportNull$$$0(15);
        }
        if (changeListManager == null) {
            VcsImplUtil.$$$reportNull$$$0(16);
        }
        if (filePath == null) {
            VcsImplUtil.$$$reportNull$$$0(17);
        }
        if ((file = LocalFileSystem.getInstance().findFileByPath(filePath)) == null) {
            return false;
        }
        FileStatus fileStatus = changeListManager.getStatus(file);
        return VcsUtil.isFileUnderVcs(project2, filePath) && fileStatus != FileStatus.UNKNOWN && fileStatus != FileStatus.IGNORED;
    }

    public static boolean isProjectSharedInVcs(@NotNull Project project2) {
        if (project2 == null) {
            VcsImplUtil.$$$reportNull$$$0(18);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (project2.isDisposed()) {
                return false;
            }
            @SystemIndependent String projectFilePath = project2.getProjectFilePath();
            ChangeListManagerEx changeListManager = ChangeListManagerEx.getInstanceEx(project2);
            return !changeListManager.isInUpdate() && projectFilePath != null && VcsImplUtil.isFileSharedInVcs(project2, changeListManager, projectFilePath);
        });
    }

    @NotNull
    public static String loadTextFromBytes(@Nullable Project project2, byte @NotNull [] bytes, @NotNull FilePath filePath) {
        if (filePath == null) {
            VcsImplUtil.$$$reportNull$$$0(19);
        }
        if (bytes == null) {
            VcsImplUtil.$$$reportNull$$$0(20);
        }
        Charset charset = DiffContentFactoryImpl.guessCharset((Project)project2, (byte[])bytes, (FilePath)filePath);
        String string2 = CharsetToolkit.decodeString((byte[])bytes, (Charset)charset);
        if (string2 == null) {
            VcsImplUtil.$$$reportNull$$$0(21);
        }
        return string2;
    }

    @Nullable
    public static VirtualFile findValidParentAccurately(@NotNull FilePath filePath) {
        VirtualFile result2;
        if (filePath == null) {
            VcsImplUtil.$$$reportNull$$$0(22);
        }
        if ((result2 = filePath.getVirtualFile()) != null) {
            return result2;
        }
        String path2 = filePath.getPath();
        if (!ApplicationManager.getApplication().isReadAccessAllowed() && (result2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(path2)) != null) {
            return result2;
        }
        Pair pair = VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)LocalFileSystem.getInstance(), (String)path2);
        return pair.first != null ? (VirtualFile)pair.first : (VirtualFile)pair.second;
    }

    @NotNull
    public static JBIterable<? extends Change> filterChangesUnderFiles(@NotNull Iterable<? extends Change> changes2, @NotNull Collection<VirtualFile> files2) {
        if (changes2 == null) {
            VcsImplUtil.$$$reportNull$$$0(23);
        }
        if (files2 == null) {
            VcsImplUtil.$$$reportNull$$$0(24);
        }
        return VcsImplUtil.filterChangesUnder(changes2, ContainerUtil.map(files2, file -> VcsUtil.getFilePath(file)));
    }

    @NotNull
    public static JBIterable<? extends Change> filterChangesUnder(@NotNull Iterable<? extends Change> changes2, @NotNull Collection<FilePath> filePaths) {
        if (changes2 == null) {
            VcsImplUtil.$$$reportNull$$$0(25);
        }
        if (filePaths == null) {
            VcsImplUtil.$$$reportNull$$$0(26);
        }
        if (filePaths.isEmpty()) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                VcsImplUtil.$$$reportNull$$$0(27);
            }
            return jBIterable;
        }
        RecursiveFilePathSet scope2 = new RecursiveFilePathSet(SystemInfoRt.isFileSystemCaseSensitive);
        scope2.addAll(filePaths);
        JBIterable jBIterable = JBIterable.from(changes2).filter(change -> VcsImplUtil.isUnderScope(scope2, change));
        if (jBIterable == null) {
            VcsImplUtil.$$$reportNull$$$0(28);
        }
        return jBIterable;
    }

    private static boolean isUnderScope(@NotNull RecursiveFilePathSet scope2, @NotNull Change change) {
        FilePath beforePath;
        if (scope2 == null) {
            VcsImplUtil.$$$reportNull$$$0(29);
        }
        if (change == null) {
            VcsImplUtil.$$$reportNull$$$0(30);
        }
        if ((beforePath = ChangesUtil.getBeforePath(change)) != null && scope2.hasAncestor(beforePath)) {
            return true;
        }
        FilePath afterPath = ChangesUtil.getAfterPath(change);
        return afterPath != null && !ChangesUtil.equalsCaseSensitive(beforePath, afterPath) && scope2.hasAncestor(afterPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 21, 27, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 21: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcsUtil/VcsImplUtil";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsKey";
                break;
            }
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreFileRoot";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListManager";
                break;
            }
            case 17: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcsUtil/VcsImplUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortVcsRootName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTextFromBytes";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "filterChangesUnder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getShortVcsRootName";
                break;
            }
            case 2: 
            case 21: 
            case 27: 
            case 28: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findIgnoredFileContentProvider";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "proposeUpdateIgnoreFile";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "generateIgnoreFileIfNeeded";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generateIgnoreFile";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isFileSharedInVcs";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isProjectSharedInVcs";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "loadTextFromBytes";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findValidParentAccurately";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "filterChangesUnderFiles";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "filterChangesUnder";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isUnderScope";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 21, 27, 28 -> new IllegalStateException(string2);
        };
    }
}

