/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.google.common.primitives.Ints;
import com.intellij.openapi.util.Couple;
import com.intellij.ui.ScrollingUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.ui.table.ScrollingTarget;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0002\u001a\u00020\u0010H\u0002J*\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00142\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J0\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u00172\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0014H\u0002J$\u0010\u0018\u001a\u00020\u00192\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006J!\u0010\u001b\u001a\u00020\u00192\b\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/vcs/log/ui/table/SelectionSnapshot;", "", "table", "Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;", "(Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;)V", "isOnTop", "", "scrollingTarget", "Lcom/intellij/vcs/log/ui/table/ScrollingTarget;", "selectedCommits", "Lit/unimi/dsi/fastutil/ints/IntSet;", "getTopGap", "", "row", "getVisibleRows", "Lkotlin/ranges/IntRange;", "Ljavax/swing/JTable;", "mapCommitsToRows", "", "graph", "Lcom/intellij/vcs/log/graph/VisibleGraph;", "scroll", "commits", "", "restore", "", "permanentGraphChanged", "scrollToRow", "delta", "(Ljava/lang/Integer;Ljava/lang/Integer;)V", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nSelectionSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionSnapshot.kt\ncom/intellij/vcs/log/ui/table/SelectionSnapshot\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1271#2,2:101\n1285#2,4:103\n1#3:107\n*S KotlinDebug\n*F\n+ 1 SelectionSnapshot.kt\ncom/intellij/vcs/log/ui/table/SelectionSnapshot\n*L\n22#1:101,2\n22#1:103,4\n*E\n"})
public final class SelectionSnapshot {
    @NotNull
    private final VcsLogGraphTable table;
    @NotNull
    private final IntSet selectedCommits;
    private final boolean isOnTop;
    @Nullable
    private final ScrollingTarget scrollingTarget;

    public SelectionSnapshot(@NotNull VcsLogGraphTable table) {
        Integer it;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.table = table;
        this.selectedCommits = (IntSet)new IntOpenHashSet();
        int[] nArray = this.table.getSelectedRows();
        List list2 = ContainerUtil.sorted((Collection)Ints.asList((int[])Arrays.copyOf(nArray, nArray.length)));
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"sorted(...)");
        List selectedRows = list2;
        Iterable $this$associateWith$iv = selectedRows;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Integer n = (Integer)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            VisibleGraph<Integer> visibleGraph = this.table.getVisibleGraph();
            Intrinsics.checkNotNull((Object)it);
            Integer n2 = visibleGraph.getRowInfo(it).getCommit();
            map2.put(t, n2);
        }
        Map selectedRowsToCommits = result$iv;
        this.selectedCommits.addAll(selectedRowsToCommits.values());
        IntRange visibleRows = this.getVisibleRows((JTable)((Object)this.table));
        if (visibleRows == null) {
            this.isOnTop = false;
            this.scrollingTarget = null;
        } else {
            Object v2;
            block5: {
                this.isOnTop = visibleRows.getFirst() == 0;
                Iterable iterable = selectedRowsToCommits.keySet();
                for (Object t : iterable) {
                    it = (Integer)t;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!visibleRows.contains(it.intValue())) continue;
                    v2 = t;
                    break block5;
                }
                v2 = null;
            }
            Integer n = v2;
            int visibleRow = n != null ? n.intValue() : visibleRows.getFirst();
            Integer n3 = (Integer)selectedRowsToCommits.get(visibleRow);
            if (n3 == null) {
                n3 = this.table.getVisibleGraph().getRowInfo(visibleRow).getCommit();
            }
            Integer n4 = n3;
            Intrinsics.checkNotNull((Object)n4);
            int visibleCommit = ((Number)n4).intValue();
            this.scrollingTarget = new ScrollingTarget(visibleCommit, this.getTopGap(visibleRow));
        }
    }

    private final int getTopGap(int row2) {
        return this.table.getCellRect((int)row2, (int)0, (boolean)false).y - this.table.getVisibleRect().y;
    }

    private final IntRange getVisibleRows(JTable table) {
        Couple couple = ScrollingUtil.getVisibleRows((JTable)table);
        Intrinsics.checkNotNullExpressionValue((Object)couple, (String)"getVisibleRows(...)");
        Couple visibleRows = couple;
        Object object = visibleRows.first;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
        int n = ((Number)object).intValue();
        Object object2 = visibleRows.second;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"second");
        IntRange range = new IntRange(n, ((Number)object2).intValue());
        if (range.isEmpty() || range.getFirst() < 0) {
            return null;
        }
        return range;
    }

    public final void restore(@NotNull VisibleGraph<Integer> graph, boolean scroll, boolean permanentGraphChanged) {
        Intrinsics.checkNotNullParameter(graph, (String)"graph");
        boolean scrollToTop = this.isOnTop && permanentGraphChanged;
        Map<Integer, Integer> commitsToRows = this.mapCommitsToRows(graph, scroll && !scrollToTop);
        this.table.getSelectionModel().setValueIsAdjusting(true);
        this.selectedCommits.forEach(arg_0 -> SelectionSnapshot.restore$lambda$2(commitsToRows, this, arg_0));
        this.table.getSelectionModel().setValueIsAdjusting(false);
        if (scroll) {
            Integer scrollingTargetRow;
            if (scrollToTop) {
                this.scrollToRow(0, 0);
            } else if (this.scrollingTarget != null && (scrollingTargetRow = commitsToRows.get(this.scrollingTarget.getCommit())) != null) {
                this.scrollToRow(scrollingTargetRow, this.scrollingTarget.getTopGap());
            }
        }
    }

    private final Map<Integer, Integer> mapCommitsToRows(VisibleGraph<Integer> graph, boolean scroll) {
        Set commits2 = new LinkedHashSet();
        commits2.addAll((Collection)this.selectedCommits);
        if (scroll && this.scrollingTarget != null) {
            commits2.add(this.scrollingTarget.getCommit());
        }
        return this.mapCommitsToRows(commits2, graph);
    }

    private final Map<Integer, Integer> mapCommitsToRows(Collection<Integer> commits2, VisibleGraph<Integer> graph) {
        Map commitsToRows = new LinkedHashMap();
        int n = graph.getVisibleCommitCount();
        for (int row2 = 0; row2 < n; ++row2) {
            Integer n2 = graph.getRowInfo(row2).getCommit();
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"getCommit(...)");
            int commit2 = ((Number)n2).intValue();
            if (commits2.remove(commit2)) {
                Integer n3 = commit2;
                Integer n4 = row2;
                commitsToRows.put(n3, n4);
            }
            if (commits2.isEmpty()) break;
        }
        return commitsToRows;
    }

    private final void scrollToRow(Integer row2, Integer delta) {
        Integer n = row2;
        Intrinsics.checkNotNull((Object)n);
        Rectangle startRect = this.table.getCellRect(n, 0, true);
        int n2 = startRect.x;
        int n3 = startRect.y;
        Integer n4 = delta;
        Intrinsics.checkNotNull((Object)n4);
        this.table.scrollRectToVisible(new Rectangle(n2, Math.max(n3 - n4, 0), startRect.width, this.table.getVisibleRect().height));
    }

    private static final void restore$lambda$2(Map $commitsToRows, SelectionSnapshot this$0, int commit2) {
        Intrinsics.checkNotNullParameter((Object)$commitsToRows, (String)"$commitsToRows");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Integer row2 = (Integer)$commitsToRows.get(commit2);
        if (row2 != null) {
            this$0.table.addRowSelectionInterval(row2, row2);
        }
    }
}

