/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.FilterPair;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000  2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001 B%\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u0017\u001a\u00020\u00022\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0014J\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u00032\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0014J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001d\u001a\u00020\u0002H\u0014J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001f\u001a\u00020\u0003H\u0014R\u0013\u0010\f\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R(\u0010\u0012\u001a\u0004\u0018\u00010\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\u00028F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006!"}, d2={"Lcom/intellij/vcs/log/ui/filter/FileFilterModel;", "Lcom/intellij/vcs/log/ui/filter/FilterModel$PairFilterModel;", "Lcom/intellij/vcs/log/VcsLogStructureFilter;", "Lcom/intellij/vcs/log/VcsLogRootFilter;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "uiProperties", "Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "(Ljava/util/Set;Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;Lcom/intellij/vcs/log/VcsLogFilterCollection;)V", "rootFilter", "getRootFilter", "()Lcom/intellij/vcs/log/VcsLogRootFilter;", "getRoots", "()Ljava/util/Set;", "filter", "structureFilter", "getStructureFilter", "()Lcom/intellij/vcs/log/VcsLogStructureFilter;", "setStructureFilter", "(Lcom/intellij/vcs/log/VcsLogStructureFilter;)V", "createFilter1", "values", "", "", "createFilter2", "getFilter1Values", "filter1", "getFilter2Values", "filter2", "Companion", "intellij.platform.vcs.log.impl"})
public final class FileFilterModel
extends FilterModel.PairFilterModel<VcsLogStructureFilter, VcsLogRootFilter> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<VirtualFile> roots;
    @NotNull
    private static final String DIR = "dir:";
    @NotNull
    private static final String FILE = "file:";
    @NotNull
    private static final Logger LOG;

    public FileFilterModel(@NotNull Set<? extends VirtualFile> roots, @NotNull MainVcsLogUiProperties uiProperties, @Nullable VcsLogFilterCollection filters) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)uiProperties, (String)"uiProperties");
        VcsLogFilterCollection.FilterKey<VcsLogStructureFilter> filterKey = VcsLogFilterCollection.STRUCTURE_FILTER;
        Intrinsics.checkNotNullExpressionValue(filterKey, (String)"STRUCTURE_FILTER");
        VcsLogFilterCollection.FilterKey<VcsLogRootFilter> filterKey2 = VcsLogFilterCollection.ROOT_FILTER;
        Intrinsics.checkNotNullExpressionValue(filterKey2, (String)"ROOT_FILTER");
        super(filterKey, filterKey2, uiProperties, filters);
        this.roots = roots;
    }

    @NotNull
    public final Set<VirtualFile> getRoots() {
        return this.roots;
    }

    @Override
    @NotNull
    protected List<String> getFilter1Values(@NotNull VcsLogStructureFilter filter1) {
        Intrinsics.checkNotNullParameter((Object)filter1, (String)"filter1");
        return Companion.getFilterValues(filter1);
    }

    @Override
    @NotNull
    protected List<String> getFilter2Values(@NotNull VcsLogRootFilter filter2) {
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter2");
        return Companion.getRootFilterValues(filter2);
    }

    @Override
    @NotNull
    protected VcsLogStructureFilter createFilter1(@NotNull List<String> values2) {
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        return Companion.createStructureFilter(values2);
    }

    @Override
    @Nullable
    protected VcsLogRootFilter createFilter2(@NotNull List<String> values2) {
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        List selectedRoots = new ArrayList();
        for (String path2 : values2) {
            VirtualFile root = LocalFileSystem.getInstance().findFileByPath(path2);
            if (root != null) {
                if (this.roots.contains(root)) {
                    selectedRoots.add(root);
                    continue;
                }
                LOG.warn("Can not find VCS root for filtering " + root);
                continue;
            }
            LOG.warn("Can not filter by root that does not exist " + path2);
        }
        if (selectedRoots.isEmpty()) {
            return null;
        }
        return VcsLogFilterObject.fromRoots(selectedRoots);
    }

    @Nullable
    public final VcsLogRootFilter getRootFilter() {
        return (VcsLogRootFilter)this.getFilter2();
    }

    @Nullable
    public final VcsLogStructureFilter getStructureFilter() {
        return (VcsLogStructureFilter)this.getFilter1();
    }

    private final void setStructureFilter(VcsLogStructureFilter filter2) {
        this.setFilter(new FilterPair<VcsLogFilter, Object>(filter2, null));
    }

    @JvmStatic
    @NotNull
    public static final List<String> getFilterValues(@NotNull VcsLogStructureFilter filter2) {
        return Companion.getFilterValues(filter2);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogStructureFilter createStructureFilter(@NotNull List<String> values2) {
        return Companion.createStructureFilter(values2);
    }

    static {
        Logger logger = Logger.getInstance(FileFilterModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u0012\u001a\u00020\u000bH\u0007J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u0012\u001a\u00020\u0014R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/vcs/log/ui/filter/FileFilterModel$Companion;", "", "()V", "DIR", "", "Lorg/jetbrains/annotations/NonNls;", "FILE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createStructureFilter", "Lcom/intellij/vcs/log/VcsLogStructureFilter;", "values", "", "extractPath", "Lcom/intellij/openapi/vcs/FilePath;", "path", "getFilterValues", "filter", "getRootFilterValues", "Lcom/intellij/vcs/log/VcsLogRootFilter;", "intellij.platform.vcs.log.impl"})
    @SourceDebugExtension(value={"SMAP\nFileFilterModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileFilterModel.kt\ncom/intellij/vcs/log/ui/filter/FileFilterModel$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1549#2:84\n1620#2,3:85\n1549#2:88\n1620#2,3:89\n1549#2:92\n1620#2,3:93\n*S KotlinDebug\n*F\n+ 1 FileFilterModel.kt\ncom/intellij/vcs/log/ui/filter/FileFilterModel$Companion\n*L\n60#1:84\n60#1:85,3\n65#1:88\n65#1:89,3\n70#1:92\n70#1:93,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getRootFilterValues(@NotNull VcsLogRootFilter filter2) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
            Collection<VirtualFile> collection = filter2.getRoots();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getRoots(...)");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getPath());
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<String> getFilterValues(@NotNull VcsLogStructureFilter filter2) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
            Collection<FilePath> collection = filter2.getFiles();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getFiles(...)");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void path2;
                FilePath filePath = (FilePath)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add((path2.isDirectory() ? FileFilterModel.DIR : FileFilterModel.FILE) + path2.getPath());
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final VcsLogStructureFilter createStructureFilter(@NotNull List<String> values2) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            Iterable $this$map$iv = values2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void path2;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.extractPath((String)path2));
            }
            return VcsLogFilterObject.fromPaths((List)destination$iv$iv);
        }

        @NotNull
        public final FilePath extractPath(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            if (StringsKt.startsWith$default((String)path2, (String)FileFilterModel.DIR, (boolean)false, (int)2, null)) {
                String string2 = path2.substring(4);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                FilePath filePath = VcsUtil.getFilePath(string2, true);
                Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
                return filePath;
            }
            if (StringsKt.startsWith$default((String)path2, (String)FileFilterModel.FILE, (boolean)false, (int)2, null)) {
                String string3 = path2.substring(5);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                FilePath filePath = VcsUtil.getFilePath(string3, false);
                Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
                return filePath;
            }
            FilePath filePath = VcsUtil.getFilePath(path2);
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
            return filePath;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

