/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.TabGroupId;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.history.FileHistoryUiFactory;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J2\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J*\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0007R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryTabsManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "historyTabs", "", "Lcom/intellij/vcs/log/history/FileHistoryTabsManager$FileHistoryTab;", "isLogDisposing", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "tabGroupId", "Lcom/intellij/ui/content/TabGroupId;", "doOpenFileHistoryTab", "Lcom/intellij/vcs/log/history/FileHistoryUi;", "logManager", "Lcom/intellij/vcs/log/impl/VcsLogManager;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "hash", "Lcom/intellij/vcs/log/Hash;", "focus", "openFileHistoryTab", "FileHistoryTab", "intellij.platform.vcs.log.impl"})
public final class FileHistoryTabsManager {
    @NotNull
    private final Project project;
    @NotNull
    private final TabGroupId tabGroupId;
    @NotNull
    private final List<FileHistoryTab> historyTabs;
    private boolean isLogDisposing;

    public FileHistoryTabsManager(@NotNull Project project2, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project2;
        Supplier<String> supplier = VcsBundle.messagePointer("file.history.tab.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
        this.tabGroupId = new TabGroupId("History", supplier, false);
        this.historyTabs = new ArrayList();
        this.project.getMessageBus().connect(coroutineScope).subscribe(VcsProjectLog.VCS_PROJECT_LOG_CHANGED, (Object)new VcsProjectLog.ProjectLogListener(){

            @Override
            public void logCreated(@NotNull VcsLogManager manager) {
                Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                isLogDisposing = false;
                ToolWindowManager.Companion.getInstance(this.getProject()).invokeLater(() -> 1.logCreated$lambda$2(manager, this));
            }

            @Override
            public void logDisposed(@NotNull VcsLogManager manager) {
                Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                isLogDisposing = true;
            }

            private static final boolean logCreated$lambda$2$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final void logCreated$lambda$2(VcsLogManager $manager, FileHistoryTabsManager this$0) {
                Intrinsics.checkNotNullParameter((Object)$manager, (String)"$manager");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                if ($manager.isDisposed()) {
                    return;
                }
                this$0.historyTabs.removeIf(arg_0 -> 1.logCreated$lambda$2$lambda$0((Function1)new Function1<FileHistoryTab, Boolean>($manager){
                    final /* synthetic */ VcsLogManager $manager;
                    {
                        this.$manager = $manager;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull FileHistoryTab it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return !this.$manager.getDataManager().getLogProviders().keySet().contains(it.getRoot());
                    }
                }, arg_0));
                Iterable $this$forEach$iv = this$0.historyTabs;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FileHistoryTab fileHistoryTab = (FileHistoryTab)element$iv;
                    boolean bl = false;
                    FilePath path2 = fileHistoryTab.component1();
                    VirtualFile root = fileHistoryTab.component2();
                    Hash hash2 = fileHistoryTab.component3();
                    this$0.doOpenFileHistoryTab($manager, path2, root, hash2, false);
                }
            }
        });
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @RequiresEdt
    @NotNull
    public final FileHistoryUi openFileHistoryTab(@NotNull VcsLogManager logManager2, @NotNull FilePath path2, @NotNull VirtualFile root, @Nullable Hash hash2) {
        Intrinsics.checkNotNullParameter((Object)logManager2, (String)"logManager");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.historyTabs.add(new FileHistoryTab(path2, root, hash2));
        return this.doOpenFileHistoryTab(logManager2, path2, root, hash2, true);
    }

    private final FileHistoryUi doOpenFileHistoryTab(VcsLogManager logManager2, FilePath path2, VirtualFile root, Hash hash2, boolean focus) {
        Hash hash3 = hash2;
        Object suffix = hash3 != null ? " (" + hash3.toShortString() + ")" : "";
        FileHistoryUi fileHistoryUi2 = VcsLogContentUtil.openLogTab(this.project, logManager2, this.tabGroupId, arg_0 -> FileHistoryTabsManager.doOpenFileHistoryTab$lambda$0(path2, (String)suffix, arg_0), new FileHistoryUiFactory(path2, root, hash2), focus);
        Disposer.register((Disposable)fileHistoryUi2, () -> FileHistoryTabsManager.doOpenFileHistoryTab$lambda$1(this, path2, root, hash2));
        Intrinsics.checkNotNull((Object)fileHistoryUi2);
        return fileHistoryUi2;
    }

    private static final String doOpenFileHistoryTab$lambda$0(FilePath $path, String $suffix, FileHistoryUi it) {
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        Intrinsics.checkNotNullParameter((Object)$suffix, (String)"$suffix");
        return $path.getName() + $suffix;
    }

    private static final void doOpenFileHistoryTab$lambda$1(FileHistoryTabsManager this$0, FilePath $path, VirtualFile $root, Hash $hash) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        Intrinsics.checkNotNullParameter((Object)$root, (String)"$root");
        if (!this$0.isLogDisposing) {
            this$0.historyTabs.remove(new FileHistoryTab($path, $root, $hash));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryTabsManager$FileHistoryTab;", "", "path", "Lcom/intellij/openapi/vcs/FilePath;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "hash", "Lcom/intellij/vcs/log/Hash;", "(Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/vcs/log/Hash;)V", "getHash", "()Lcom/intellij/vcs/log/Hash;", "getPath", "()Lcom/intellij/openapi/vcs/FilePath;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.vcs.log.impl"})
    private static final class FileHistoryTab {
        @NotNull
        private final FilePath path;
        @NotNull
        private final VirtualFile root;
        @Nullable
        private final Hash hash;

        public FileHistoryTab(@NotNull FilePath path2, @NotNull VirtualFile root, @Nullable Hash hash2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            this.path = path2;
            this.root = root;
            this.hash = hash2;
        }

        @NotNull
        public final FilePath getPath() {
            return this.path;
        }

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        @Nullable
        public final Hash getHash() {
            return this.hash;
        }

        @NotNull
        public final FilePath component1() {
            return this.path;
        }

        @NotNull
        public final VirtualFile component2() {
            return this.root;
        }

        @Nullable
        public final Hash component3() {
            return this.hash;
        }

        @NotNull
        public final FileHistoryTab copy(@NotNull FilePath path2, @NotNull VirtualFile root, @Nullable Hash hash2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            return new FileHistoryTab(path2, root, hash2);
        }

        public static /* synthetic */ FileHistoryTab copy$default(FileHistoryTab fileHistoryTab, FilePath filePath, VirtualFile virtualFile, Hash hash2, int n, Object object) {
            if ((n & 1) != 0) {
                filePath = fileHistoryTab.path;
            }
            if ((n & 2) != 0) {
                virtualFile = fileHistoryTab.root;
            }
            if ((n & 4) != 0) {
                hash2 = fileHistoryTab.hash;
            }
            return fileHistoryTab.copy(filePath, virtualFile, hash2);
        }

        @NotNull
        public String toString() {
            return "FileHistoryTab(path=" + this.path + ", root=" + this.root + ", hash=" + this.hash + ")";
        }

        public int hashCode() {
            int result2 = this.path.hashCode();
            result2 = result2 * 31 + this.root.hashCode();
            result2 = result2 * 31 + (this.hash == null ? 0 : this.hash.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileHistoryTab)) {
                return false;
            }
            FileHistoryTab fileHistoryTab = (FileHistoryTab)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)fileHistoryTab.path)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.root, (Object)fileHistoryTab.root)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.hash, (Object)fileHistoryTab.hash);
        }
    }
}

