/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.history.CommitMetadataWithPath;
import com.intellij.vcs.log.history.MaybeDeletedFilePath;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001aH\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\n\"\b\b\u0000\u0010\u000b*\u00020\r\"\u0004\b\u0001\u0010\f*\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\n2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\nH\u0002\u00a8\u0006\u000f"}, d2={"createCommitMetadataWithPath", "Lcom/intellij/vcs/log/history/CommitMetadataWithPath;", "Lcom/intellij/vcs/log/VcsLogObjectsFactory;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "revision", "Lcom/intellij/openapi/vcs/history/VcsFileRevisionEx;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "union", "Lcom/intellij/util/containers/MultiMap;", "K", "V", "", "map", "intellij.platform.vcs.log.impl"})
public final class FileHistoryFiltererKt {
    private static final <K, V> MultiMap<K, V> union(MultiMap<K, V> $this$union, MultiMap<K, V> map2) {
        if ($this$union.isEmpty()) {
            return map2;
        }
        if (map2.isEmpty()) {
            return $this$union;
        }
        MultiMap result2 = new MultiMap();
        result2.putAllValues($this$union);
        result2.putAllValues(map2);
        return result2;
    }

    private static final CommitMetadataWithPath createCommitMetadataWithPath(VcsLogObjectsFactory $this$createCommitMetadataWithPath, VcsLogStorage storage, VcsFileRevisionEx revision, VirtualFile root) {
        Hash hash2 = $this$createCommitMetadataWithPath.createHash(revision.getRevisionNumber().asString());
        Intrinsics.checkNotNullExpressionValue((Object)hash2, (String)"createHash(...)");
        Hash commitHash = hash2;
        List list2 = CollectionsKt.emptyList();
        long l = revision.getRevisionDate().getTime();
        String string2 = revision.getCommitMessage();
        Intrinsics.checkNotNull((Object)string2);
        String string3 = CommitPresentationUtil.getSubject(string2);
        String string4 = revision.getAuthor();
        Intrinsics.checkNotNull((Object)string4);
        String string5 = revision.getAuthorEmail();
        Intrinsics.checkNotNull((Object)string5);
        String string6 = revision.getCommitMessage();
        Intrinsics.checkNotNull((Object)string6);
        String string7 = revision.getCommitterName();
        Intrinsics.checkNotNull((Object)string7);
        String string8 = revision.getCommitterEmail();
        Intrinsics.checkNotNull((Object)string8);
        Date date = revision.getAuthorDate();
        Intrinsics.checkNotNull((Object)date);
        VcsCommitMetadata vcsCommitMetadata = $this$createCommitMetadataWithPath.createCommitMetadata(commitHash, list2, l, root, string3, string4, string5, string6, string7, string8, date.getTime());
        Intrinsics.checkNotNullExpressionValue((Object)vcsCommitMetadata, (String)"createCommitMetadata(...)");
        VcsCommitMetadata metadata = vcsCommitMetadata;
        int n = storage.getCommitIndex(commitHash, root);
        FilePath filePath = revision.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getPath(...)");
        return new CommitMetadataWithPath(n, metadata, new MaybeDeletedFilePath(filePath, revision.isDeleted()));
    }

    public static final /* synthetic */ MultiMap access$union(MultiMap $receiver, MultiMap map2) {
        return FileHistoryFiltererKt.union($receiver, map2);
    }

    public static final /* synthetic */ CommitMetadataWithPath access$createCommitMetadataWithPath(VcsLogObjectsFactory $receiver, VcsLogStorage storage, VcsFileRevisionEx revision, VirtualFile root) {
        return FileHistoryFiltererKt.createCommitMetadataWithPath($receiver, storage, revision, root);
    }
}

